UNIT sloproc;

(*
   ------------------------------------------------------------------------
   AUTOR:   Martin Kochloefl
            Kreuzstr. 2
            8052 Moosburg          Tel. 08761-1247
   ------------------------------------------------------------------------
   REV:                       2.02  11.02.1991
   DATEI:                     SLOPROC.PAS
   SPRACHE:                   TURBO PASCAL 6.0
   EINZUBINDENDE UNITS:       CRT
                              SCREEN.PAS in Datei SCREEN.PAS
                              CONFIG.PAS in Datei CONFIG.PAS
   UNIT GEHRT ZUM PROGRAMM:  SUPERLOTTO in Datei SLOTTO.PAS

   LETZTE NDERUNG: Dokumentation des Units
                    TP6.0 und ARJ-Archiv
   ------------------------------------------------------------------------

   Das UNIT sloproc beinhaltet Hilfsprozeduren zum Schreiben von Zahlen
   auf den Bildschirm fr das Programm SUPERLOTTO.

   WELCHETREFFER (NUMMER DER ZAHL) : BOOLEAN;
   Untersucht gesetzte und gezogene Zahlen und ermittelt dann in TRS_ZAHLEN
   Treffer. Ergebnis ist, ob die xte gesetzte Zahl ein Treffer ist.


   ANZAHLTREFFER : ANZAHL
   Ermittelt die Anzahl der Treffer.

   NORMAL_ZAHL
   GESETZTE_ZAHL
   GEZOGENE_ZAHL
   UEBEREIN_ZAHL
   Hilfsprozeduren fr WRZAHL.

   WRZAHL(ZAHL, ATTRIBUT)
   Schreibt eine Zahl ins Kreuzfeld mit dem gewhlten Attribut.

   WANDLE(ZAHL, NULLER)
   Wandelt eine Zahl in einen STRING um und falls NULLER gesetzt,
   fgt fhrende Nuller hinzu.

   WR_GEWINN
   Schreibt den Gewinn hin.

   WR_WETTE
   Schreibt den Einsatz hin.

   WR_KREDIT
   Schreibt den Kredit hin.

   WR_GESETZT
   Schreibt alle gesetzten Zahlen ins Setz- und Kreuzfeld.

   WR_GEZOGEN
   Schreibt alle bis jetzt gezogenen Zahlen ins Zieh- und Kreuzfeld.

   WR_RISIKO(REVERS-ATTRIBUT BEI RISIKOZAHL>0)
   Erzeugt ein laufendes Risiko.

   WR_AUSSPIELUNG (SOUND JA/NEIN)
   Erzeugt eine laufende Ausspielung.

   NEU_GESETZT
   Setzt alle gesetzten Zahlen auf 0 und leert das Setzfeld.

   NEU_GEZOGEN
   Setzt alle gezogenen Zahlen auf 0 und leert das Ziehfeld.

   NEU_RISIKO
   Setzt alle Risikozahlen auf 0 und leert das Risikofeld.

   NORM_FELD
   Setzt alle Attribute im Kreuzfeld auf NORMAL zurck.

   MELDUNG (STRING)
   Schreibt eine einzeilige Meldung.

   MELDUNG2 (STRING)
   Schreibt in die zweite Zeile der Meldung.

   WR_GEWINNE (ANZAHL GESETZTER ZAHLEN, ANZAHL MGLICHER TREFFER)
   Schreibt links unten alle Gewinnmglichkeiten hin.

   ANLEITUNG
   Zeigt die Anleitung auf dem Bildschirm.

   SOUND2 (HHE)
   Erzeugt Sound, wenn die Variable SND auf TRUE gesetzt ist.

   DELAY2 (LNGE)
   Pause, deren Lnge von der gewhlten Geschwindigkeit abhngig ist.

   PUFFER_LEEREN
   Tastaturpuffer wird abgearbeitet.

*)

INTERFACE

USES crt, screen, config;

CONST
      mzeile  = 2;   (* Bildschirmposition fr alle Meldungen und das Men *)
      mspalte = 3;

TYPE
     string7 = STRING[7];
     zattr   = (no, gs, gz, ue);
     (* Attribut fr Zahlen :  no = normal
                               gs = gesetzt
                               gz = gezogen
                               ue = bereinstimmend gesetzt und gezogen
     *)

VAR kredit, wette, gewinn : LONGINT;
    gz_zahlen             : ARRAY[0..20] OF BYTE;    (* gezogene Zahlen *)
    gs_zahlen             : ARRAY[0..10] OF BYTE;    (* gesetzte Zahlen *)
    ri_zahlen             : ARRAY[0..10] OF BYTE;    (* Risikozahlen *)
    trs_zahlen            : ARRAY[0..10] OF BOOLEAN; (* Treffer bei gesetzt *)
    trz_zahlen            : ARRAY[0..20] OF BOOLEAN; (* Treffer bei gezogen *)
    snd                   : BOOLEAN;                 (* SOUND ja/nein *)

FUNCTION welchetreffer(k : BYTE) : BOOLEAN;
FUNCTION anzahltreffer : BYTE;
PROCEDURE normal_zahl(wx, wy, zahl : BYTE);
PROCEDURE gesetzte_zahl(wx, wy, zahl : BYTE);
PROCEDURE gezogene_zahl(wx, wy, zahl : BYTE);
PROCEDURE ueberein_zahl(wx, wy, zahl : BYTE);
PROCEDURE wrzahl(zahl : BYTE; zatb : zattr);
FUNCTION wandle(zahl : LONGINT; nuller : BOOLEAN) : string7;
PROCEDURE wr_gewinn;
PROCEDURE wr_wette;
PROCEDURE wr_kredit;
PROCEDURE wr_gesetzt;
PROCEDURE wr_gezogen;
PROCEDURE wr_risiko(risk : BOOLEAN);
PROCEDURE wr_ausspielung(snd : BOOLEAN);
PROCEDURE neu_gesetzt;
PROCEDURE neu_gezogen;
PROCEDURE neu_risiko;
PROCEDURE norm_feld;
PROCEDURE meldung(was : STRING);
PROCEDURE meldung2(was : STRING);
PROCEDURE wr_gewinne(anzahl, anztr : BYTE);
PROCEDURE anleitung;
PROCEDURE sound2(s : WORD);
PROCEDURE delay2(lang : WORD);
PROCEDURE puffer_leeren;

IMPLEMENTATION

   FUNCTION welchetreffer;

   VAR
       i, j : INTEGER;
       ok   : BOOLEAN;

   BEGIN
      ok := FALSE;
      FOR i := 1 TO 10
      DO trs_zahlen[i] := FALSE;
      FOR i := 1 TO 20
      DO trz_zahlen[i] := FALSE;
      FOR i := 1 TO 10
      DO FOR j := 1 TO 20
         DO IF gs_zahlen[i] = gz_zahlen[j]
            THEN IF gs_zahlen[i] <> 0
               THEN BEGIN
                  trs_zahlen[i] := TRUE;
                  trz_zahlen[j] := TRUE;
                  IF j = k
                  THEN ok := TRUE;
               END;
      welchetreffer := ok;
   END;

   FUNCTION anzahltreffer;

   VAR
       i, j, anztr : BYTE;

   BEGIN
      anztr := 0;
      FOR i := 1 TO 10
      DO FOR j := 1 TO 20
         DO IF gs_zahlen[i] = gz_zahlen[j]
            THEN IF gs_zahlen[i] <> 0
               THEN INC(anztr);
      anzahltreffer := anztr;
   END;

   PROCEDURE norm_zahl(wx, wy, i, zahl : BYTE; treffer : BOOLEAN);

   VAR
       zstr  : STRING[2];
       attri : tattr;

   BEGIN
      IF (zahl MOD 2) = 1
      THEN BEGIN
         IF treffer
         THEN attri := rr
         ELSE attri := r;
      END
      ELSE BEGIN
         IF treffer
         THEN attri := rb
         ELSE attri := b;
      END;
      STR(zahl:2, zstr);
      IF zahl < 10
      THEN zstr[1] := '0';
      IF zahl = 0
      THEN BEGIN
         attri := n;
         zstr := '  ';
      END;
      IF zahl = 99
      THEN BEGIN
         attri := rr;
         zstr := '  ';
      END;
      bwr(wx + 1 + 3 * ((i - 1) MOD 20), wy + 1 + 2 * ((i - 1) DIV 20), attri, zstr);
   END;

   PROCEDURE ausgabezahl(wx, wy, zahl : BYTE; attri : tattr);

   VAR
       zstr : STRING[2];

   BEGIN
      STR(zahl:2, zstr);
      IF zahl < 10
      THEN zstr[1] := '0';
      IF zahl > 0
      THEN bwr(wx + 1 + 3 * ((zahl - 1) MOD 20),
               wy + 1 + 2 * ((zahl - 1) DIV 20), attri, zstr);
   END;

   PROCEDURE normal_zahl;

   VAR
       attri : tattr;

   BEGIN
      IF (zahl MOD 2) = 1
      THEN attri := r
      ELSE attri := b;
      ausgabezahl(wx, wy, zahl, attri);
   END;

   PROCEDURE gesetzte_zahl;

   VAR
       attri : tattr;

   BEGIN
      IF (zahl MOD 2) = 1
      THEN attri := rr
      ELSE attri := rb;
      ausgabezahl(wx, wy, zahl, attri);
   END;

   PROCEDURE gezogene_zahl;

   VAR
       attri : tattr;

   BEGIN
      IF (zahl MOD 2) = 1
      THEN attri := br
      ELSE attri := bb;
      ausgabezahl(wx, wy, zahl, attri);
   END;

   PROCEDURE ueberein_zahl;

   VAR
       attri : tattr;

   BEGIN
      IF (zahl MOD 2) = 1
      THEN attri := rbr
      ELSE attri := rbb;
      ausgabezahl(wx, wy, zahl, attri);
   END;

   PROCEDURE wrzahl;

   CONST zx  = 20;
      zy        = 15;

   BEGIN
      CASE zatb OF
         no : normal_zahl(zx, zy, zahl);
         gs : gesetzte_zahl(zx, zy, zahl);
         gz : gezogene_zahl(zx, zy, zahl);
         ue : ueberein_zahl(zx, zy, zahl);
      END;
   END;

   FUNCTION wandle;

   VAR
       h : string7;
       i : BYTE;

   BEGIN
      STR(zahl:7, h);
      IF nuller
      THEN FOR i := 1 TO 7
         DO IF h[i] = ' '
            THEN h[i] := '0';
      wandle := h;
   END;

   PROCEDURE wr_gewinn;

   BEGIN
      bwr(73, 13, f, wandle(gewinn, FALSE));
   END;

   PROCEDURE wr_kredit;

   BEGIN
      bwr(63, 7, f, wandle(kredit, FALSE));
   END;

   PROCEDURE wr_wette;

   BEGIN
      bwr(73, 7, f, wandle(wette, FALSE));
   END;

   PROCEDURE wr_gesetzt;

   VAR
       i : INTEGER;

   BEGIN
      FOR i := 1 TO 10
      DO BEGIN
         norm_zahl(20, 6, i, gs_zahlen[i], trs_zahlen[i]);
         IF trs_zahlen[i]
         THEN wrzahl(gs_zahlen[i], ue)
         ELSE wrzahl(gs_zahlen[i], gs);
      END;
   END;

   PROCEDURE wr_gezogen;

   VAR
       i : INTEGER;

   BEGIN
      FOR i := 1 TO 20
      DO BEGIN
         norm_zahl(20, 9, i, gz_zahlen[i], trz_zahlen[i]);
         IF trz_zahlen[i]
         THEN wrzahl(gz_zahlen[i], ue)
         ELSE wrzahl(gz_zahlen[i], gz);
      END;
   END;

   PROCEDURE wr_risiko;

   VAR
       i : INTEGER;

   BEGIN
      FOR i := 1 TO 10
      DO norm_zahl(20, 12, i, ri_zahlen[i], risk);
   END;

   PROCEDURE wr_ausspielung;

   VAR
       i, j : INTEGER;

   BEGIN
      FOR j := 1 TO 10
      DO BEGIN
         FOR i := 1 TO j
         DO norm_zahl(20, 12, i, 99, TRUE);
         IF snd
         THEN BEGIN
            sound(60 + 7 * j);
            delay(40);
         END;
      END;
      nosound;
      FOR i := 1 TO 10
      DO norm_zahl(20, 12, i, 0, FALSE);
   END;

   PROCEDURE neu_gesetzt;

   VAR
       i : INTEGER;

   BEGIN
      FOR i := 0 TO 10
      DO BEGIN
         gs_zahlen[i] := 0;
         trs_zahlen[i] := FALSE;
      END;
      wr_gesetzt;
   END;

   PROCEDURE neu_gezogen;

   VAR
       i : INTEGER;

   BEGIN
      FOR i := 0 TO 20
      DO BEGIN
         gz_zahlen[i] := 0;
         trz_zahlen[i] := FALSE;
      END;
      wr_gezogen;
   END;

   PROCEDURE neu_risiko;

   VAR
       i : INTEGER;

   BEGIN
      FOR i := 0 TO 10
      DO ri_zahlen[i] := 0;
      wr_risiko(FALSE);
   END;

   PROCEDURE norm_feld;

   VAR
       i : BYTE;

   BEGIN
      FOR i := 1 TO 80 DO wrzahl(i, no);
   END;

   PROCEDURE meldung;

   BEGIN
      bwr(mspalte, mzeile, f, COPY(was + leerzeile, 1, 77));
      bwn(mspalte, SUCC(mzeile), COPY(leerzeile, 1, 77));
   END;

   PROCEDURE meldung2;

   BEGIN
      bwr(mspalte, SUCC(mzeile), f, COPY(was + leerzeile, 1, 77));
   END;

   PROCEDURE wr_gewinne;

   VAR
       i, j             : BYTE;
       hstr, astr, zstr : STRING;

   BEGIN
      j := 1;
      IF anzahl > 0
      THEN BEGIN
         STR(anzahl:2, astr);
         FOR i := 1 TO 10
         DO BEGIN
            IF gew[anzahl, i] > 0
            THEN BEGIN
               STR(i:2, zstr);
               STR(wette * gew[anzahl, i]:7, hstr);
               zstr := zstr + ' ' + txt_aus + ' ' + astr + ' ' + hstr;
               IF anztr = i
               THEN bwr(2, 17 + j, rb, zstr)
               ELSE bwr(2, 17 + j, n, zstr);
               INC(j);
            END;
         END;
      END;
      FOR i := j TO 6
      DO bwr(2, 17 + i, n, COPY(leerzeile, 1, 17));
   END;

   PROCEDURE anleitung;

   TYPE sob = SET OF BYTE;

      PROCEDURE seite(s : BYTE; hell : sob);

      VAR
          ch    : CHAR;
          s_str : STRING;
          i     : INTEGER;

      BEGIN
         clrscr;
         kasten(2, 2, 78, 23);
         STR(s, s_str);
         bwr(59, 1, rr, ' ANLEITUNG SEITE '+s_str+' ');
         FOR i := 1 TO 23
         DO IF (i IN hell)
            THEN bwr(3, i + 1, f, txt_anl[23 * (s - 1) + i])
            ELSE bwn(3, i + 1, txt_anl[23 * (s - 1) + i]);
         bwr(3, 25, rr, ' ' + txt_fort + ' ');
         ch := readkey;
      END;

   BEGIN
      seite(1,[2, 13, 14, 21, 22, 23]);
      seite(2,[1]);
      seite(3,[1, 22, 23]);
   END;

   PROCEDURE sound2;

   BEGIN
      IF snd
      THEN sound(s);
   END;

   PROCEDURE delay2;

   BEGIN
      delay(lang DIV rechner);
   END;

   PROCEDURE puffer_leeren;

   VAR
       ch : CHAR;

   BEGIN
      WHILE keypressed
      DO ch := readkey;
   END;

BEGIN
END.
