UNIT screen;

(*
   ------------------------------------------------------------------------
   AUTOR:   Martin Kochloefl
            Kreuzstr. 2
            8052 Moosburg          Tel. 08761-1247
   ------------------------------------------------------------------------
   REV:                       2.02  11.02.1991
   DATEI:                     SCREEN.PAS
   SPRACHE:                   TURBO PASCAL 6.0
   EINZUBINDENDE UNITS:       CRT
                              DOS
   UNIT GEHRT ZUM PROGRAMM:  SUPERLOTTO in Datei SLOTTO.PAS

   LETZTE NDERUNG: Dokumentation des Units
                    TP6.0 + ARJ-Archiv
   ------------------------------------------------------------------------

   Das UNIT screen beinhaltet Prozeduren zur direkten Ausgabe von Text
   auf den Bildschirm. Dies ist zwar ab TP 5.0 auch mit direct_video
   mglich, jedoch wurde das Programm bereits frher geschrieben und auer-
   dem sind diese Routinen noch etwas schneller, gerade bei der Ausgabe
   einzelner Zeichen. Weiterhin sind Routinen zur graphischen Darstellung
   auf dem Textbildschirm vorhanden.

   SETSYMBOL ( Spalte, Zeile, Nummer des Symbol, Bildschirmattribut)
   Setzt ein Zeichen an die vorgegebene Position mit einem bestimmten
   Bildschirmattribut.

   BWN ( Spalte, Zeile, Text)
   Schreibt Text an die vorgegebene Position mit dem Attribut N=Normal

   BWR ( Spalte, Zeile, Bildschirmattribut, Text)
   Schreibt Text an die vorgegebene Position mit einem bestimmten
   Bildschirmattribut.

   KASTEN ( Spalte, Zeile, Breite, Hhe)
   Zeichnet ein Rechteck, wobei Spalte und Zeile innerhalb des Rechtecks
   liegen.

   DKASTEN ( Spalte, Zeile, Breite, Hhe)
   Wie KASTEN, jedoch wird eine doppelte Linie gezogen.

   ECKLINIE ( Spalte, Zeile, Lnge)
   Zeichnet eine horizontale Linie an deren Rndern vertikale Striche sind.

   KREUZFELD ( Spalte, Zeile, Breite, Hhe)
   Zeichnet ein Rechteck der mit Kstchen gefllt ist und zwar so, da in
   jedes Kstchen eine zweistellige Zahl Platz hat. Die Breite und Hhe geben
   dabei die horizontale und vertikale Anzahl der Kstchen an.

   WSCHIRM
   Setzt die Bildschirmattribute fr den vorgegebenen Modus, wobei
   der Modus in der globalen Variablen SCHIRM sich befindet.
   AUTO = autodetect (automatische Bildschirmerkennung)
   MONO = Monochrombildschirm (Hercules usw.)
   FARBE oder COLOR = Farbbildschirm (CGA,EGA,VGA usw.)

*)

INTERFACE

USES crt, dos;

CONST
   hor1      = 196;  (* Bildschirmcodes fr graphische Zeichen mit   *)
   ver1      = 179;  (* folgender Bedeutung :                        *)
   llc1      = 192;  (* 1.Buchstabe:  l = lower Corner (untere Ecke) *)
   ulc1      = 218;  (*               u = upper Corner (obere  Ecke) *)
   lrc1      = 217;  (* 2.Buchstabe:  l = left  Corner (linke  Ecke) *)
   urc1      = 191;  (*               r = right Corner (rechte Ecke) *)
   hor2      = 205;  (*             ver = vertikale Linie            *)
   ver2      = 186;  (*             hor = horizontale Linie          *)
   llc2      = 200;  (* 4.Buchstabe:  1 = einfache Linie             *)
   ulc2      = 201;  (*               2 = doppelte Linie             *)
   lrc2      = 188;
   urc2      = 187;

TYPE
   tattr     = (n, f, r, b, rr, rb, br, bb, rbr, rbb);

   (*
      Bildschirmattribute speziell nur fr das SUPERLOTTO-Programm:

      n   = Normalmodus
      f   = hervorgehoben
      r   = ROT
      b   = BLAU
      rr  = revers ROT
      rb  = revers BLAU
      br  = blinkend ROT
      bb  = blinkend BLAU
      rbr = revers blinkend ROT
      rbb = revers blinkend BLAU

      Im Monochrommodus ist ROT  = Normaldarstellung
                            BLAU = hervorgehoben oder fett

   *)

VAR
   msc, (* Start des Bildschirmspeichers GEWHLT *)
   fs,  (* Start des Bildschirmspeichers FARBE oder LCD *)
   ms,  (* Start des Bildschirmspeichers MONOCHROM *)

   atbn, atbf, atbr, atbb, atbrr, atbrb, atbbr, atbbb, atbrbr, atbrbb,
   (* gewhlte Bildschirmattribute *)

   mn, mf, mr, mb, mrr, mrb, mbr, mbb, mrbr, mrbb,
   (* Bildschirmattribute fr den MONO-Modus *)

   fn, ff, fr, fb, frr, frb, fbr, fbb, frbr, frbb,
   (* Bildschirmattribute fr den FARBE-Modus *)

   ln, lf, lr, lb, lrr, lrb, lbr, lbb, lrbr, lrbb : WORD;
   (* Bildschirmattribute fr den LCD-Modus *)


   schirm,                 (* Variable fr Bildschirmart *)
   leerzeile : STRING;     (* Variable zum auffllen von Strings *)

PROCEDURE setsymbol(x, y, symbol : INTEGER; attribute : tattr);
PROCEDURE bwr(x, y : INTEGER; attribute : tattr; was : string);
PROCEDURE bwn(x, y : INTEGER; was : string);
PROCEDURE kasten(x, y, xl, yl : BYTE);
PROCEDURE dkasten(x, y, xl, yl : BYTE);
PROCEDURE ecklinie(x, y, l : BYTE);
PROCEDURE kreuzfeld(x, y, xl, yl : BYTE);
PROCEDURE wschirm;

IMPLEMENTATION

   PROCEDURE setsymbol;

   VAR
      os  : INTEGER;
      atb : WORD;

   BEGIN
      CASE attribute OF
         n   : atb := atbn;
         f   : atb := atbf;
         r   : atb := atbr;
         b   : atb := atbb;
         rr  : atb := atbrr;
         rb  : atb := atbrb;
         br  : atb := atbbr;
         bb  : atb := atbbb;
         rbr : atb := atbrbr;
         rbb : atb := atbrbb;
      END;
      (* Attribut wird festgelegt *)

      os := 160 * PRED(y) + (PRED(x) SHL 1);
      (* OFFSET wird aus Spalte und Zeile berechnet *)

      MEM[ms:os] := symbol;
      MEM[ms:SUCC(os)] := atb;
      (* Zeichen und Attribut werden direkt in den Bildschirmspeicher
         geschrieben *)

   END;

   PROCEDURE bwr;

   VAR
       hx, hy,  (* Hilfsvariablen zur Offsetberechnung *)
       os, i   : INTEGER;
       atb     : WORD;

   BEGIN
      CASE attribute OF
         n :   atb := atbn;
         f :   atb := atbf;
         r :   atb := atbr;
         b :   atb := atbb;
         rr :  atb := atbrr;
         rb :  atb := atbrb;
         br :  atb := atbbr;
         bb :  atb := atbbb;
         rbr : atb := atbrbr;
         rbb : atb := atbrbb;
      END;
      (* Attribut wird festgelegt *)

      hy := 160 * PRED(y);
      hx := PRED(PRED(x));
      (* die Ausgabezeile wird vorberechnet *)

      FOR i := 1 TO LENGTH(was)
      DO BEGIN
         os := hy + ((hx + i) SHL 1);
         MEM[ms:os] := ORD(was[i]);
         MEM[ms:SUCC(os)] := atb;
      END;
      (* Zeichen und Attribut werden direkt in den Bildschirmspeicher
         geschrieben *)

   END;

   PROCEDURE bwn;

   VAR
       hx, hy,  (* Hilfsvariablen zur Offsetberechnung *)
       os, i   : INTEGER;

   BEGIN
      hy := 160 * PRED(y);
      hx := PRED(PRED(x));
      (* die Ausgabezeile wird vorberechnet *)

      FOR i := 1 TO LENGTH(was)
      DO BEGIN
         os := hy + ((hx + i) SHL 1);
         MEM[ms:os] := ORD(was[i]);
         MEM[ms:SUCC(os)] := atbn;
      END;
      (* Zeichen und Attribut werden direkt in den Bildschirmspeicher
         geschrieben *)

   END;

   PROCEDURE kasten;

   VAR
       i : BYTE;

   BEGIN
      setsymbol(x - 1, y - 1, ulc1, n);
      FOR i := y TO y + yl - 1 DO setsymbol(x - 1, i, ver1, n);
      setsymbol(x - 1, y + yl, llc1, n);
      FOR i := x TO x + xl - 1 DO setsymbol(i, y - 1, hor1, n);
      FOR i := x TO x + xl - 1 DO setsymbol(i, y + yl, hor1, n);
      setsymbol(x + xl, y - 1, urc1, n);
      FOR i := y TO y + yl - 1 DO setsymbol(x + xl, i, ver1, n);
      setsymbol(x + xl, y + yl, lrc1, n);
   END;

   PROCEDURE dkasten;

   VAR
       i : BYTE;

   BEGIN
      setsymbol(x - 1, y - 1, ulc2, n);
      FOR i := y TO y + yl - 1 DO setsymbol(x - 1, i, ver2, n);
      setsymbol(x - 1, y + yl, llc2, n);
      FOR i := x TO x + xl - 1 DO setsymbol(i, y - 1, hor2, n);
      FOR i := x TO x + xl - 1 DO setsymbol(i, y + yl, hor2, n);
      setsymbol(x + xl, y - 1, urc2, n);
      FOR i := y TO y + yl - 1 DO setsymbol(x + xl, i, ver2, n);
      setsymbol(x + xl, y + yl, lrc2, n);
   END;

   PROCEDURE ecklinie;

   VAR
       i : BYTE;

   BEGIN
      setsymbol(x, y, 195, n);
      FOR i := x + 1 TO x + l - 1 DO setsymbol(i, y, hor1, n);
      setsymbol(x + l, y, 180, n);
   END;

   PROCEDURE kreuzfeld;

   VAR
       i, j : INTEGER;

   BEGIN
      setsymbol(x, y, ulc1, n);
      FOR i := 0 TO xl - 1
      DO BEGIN
         setsymbol(x + 3 * i + 1, y, hor1, n);
         setsymbol(x + 3 * i + 2, y, hor1, n);
         setsymbol(x + 3 * i + 3, y, 194, n);
      END;
      setsymbol(x + 3 * xl, y, urc1, n);

      FOR j := 1 TO yl
      DO FOR i := 0 TO xl - 1
         DO BEGIN
            setsymbol(x + 3 * i + 1, y + 2 * j, hor1, n);
            setsymbol(x + 3 * i + 2, y + 2 * j, hor1, n);
            setsymbol(x + 3 * i + 3, y + 2 * j, hor1, n);
         END;

      FOR j := 1 TO xl
      DO FOR i := 0 TO yl - 1
         DO BEGIN
            setsymbol(x + 3 * j, y + 2 * i + 1, ver1, n);
            setsymbol(x + 3 * j, y + 2 * i + 2, 197, n);
         END;

      FOR i := 0 TO yl - 1
      DO BEGIN
         setsymbol(x, y + 2 * i + 1, ver1, n);
         setsymbol(x, y + 2 * i + 2, 195, n);
      END;
      setsymbol(x, y + 2 * yl, llc1, n);
      FOR i := 0 TO xl - 1
      DO BEGIN
         setsymbol(x + 3 * i + 1, y + 2 * yl, hor1, n);
         setsymbol(x + 3 * i + 2, y + 2 * yl, hor1, n);
         setsymbol(x + 3 * i + 3, y + 2 * yl, 193, n);
      END;
      FOR i := 0 TO yl - 1
      DO BEGIN
         setsymbol(x + 3 * xl, y + 2 * i + 1, ver1, n);
         setsymbol(x + 3 * xl, y + 2 * i + 2, 180, n);
      END;
      setsymbol(x + 3 * xl, y + 2 * yl, lrc1, n);
   END;

   PROCEDURE wschirm;

   VAR
       regs : registers;

   BEGIN
      regs.ah := 15;
      intr(16, regs);
      IF schirm = 'AUTO'
      THEN BEGIN
         IF (regs.al = 2) OR (regs.al = 7)
         THEN schirm := 'MONO'
         ELSE schirm := 'COLOR';
      END ;
      (* Automatische Modusermittlung mit INTR *)

      ms := msc;
      atbn := mn;
      atbf := mf;
      atbr := mr;
      atbb := mb;
      atbrr := mrr;
      atbrb := mrb;
      atbbr := mbr;
      atbbb := mbb;
      atbrbr := mrbr;
      atbrbb := mrbb;
      (* vorgegeben wird der MONO-Modus *)

      IF (schirm = 'FARBE') OR (schirm = 'COLOR')
      THEN BEGIN
         ms := fs;
         atbn := fn;
         atbf := ff;
         atbr := fr;
         atbb := fb;
         atbrr := frr;
         atbrb := frb;
         atbbr := fbr;
         atbbb := fbb;
         atbrbr := frbr;
         atbrbb := frbb;
      END;
      IF schirm = 'LCD'
      THEN BEGIN
         ms := fs;
         atbn := ln;
         atbf := lf;
         atbr := lr;
         atbb := lb;
         atbrr := lrr;
         atbrb := lrb;
         atbbr := lbr;
         atbbb := lbb;
         atbrbr := lrbr;
         atbrbb := lrbb;
      END;
      clrscr;
   END;

BEGIN
(* Vorbesetzung aller Variablen mit den jeweiligen Standardattributen *)

FILLCHAR(leerzeile,SIZEOF(leerzeile),' ');
leerzeile[0]:=CHAR(PRED(SIZEOF(leerzeile)));
schirm := 'AUTO';
msc := $B000;
fs := $B800;
mn := 7;
mf := 10;
mr := 2;
mb := 10;
mrr := 112;
mrb := 112;
mbr := 130;
mbb := 138;
mrbr := 240;
mrbb := 240;
fn := 7;
ff := 15;
fr := 12;
fb := 9;
frr := 79;
frb := 31;
fbr := 140;
fbb := 137;
frbr := 207;
frbb := 159;
ln := 6;
lf := 15;
lr := 12;
lb := 9;
lrr := 79;
lrb := 31;
lbr := 140;
lbb := 137;
lrbr := 207;
lrbb := 159;
END.

