UNIT config;

(*
   ------------------------------------------------------------------------
   AUTOR:   Martin Kochloefl
            Kreuzstr. 2
            8052 Moosburg          Tel. 08761-1247
   ------------------------------------------------------------------------
   REV:                       2.03  11.02.1991
   DATEI:                     CONFIG.PAS
   SPRACHE:                   TURBO PASCAL 6.0
   EINZUBINDENDE UNITS:       DOS
                              SCREEN     in Datei SCREEN.PAS
   UNIT GEHRT ZUM PROGRAMM:  SUPERLOTTO in Datei SLOTTO.PAS

   LETZTE NDERUNG: Dokumentation des Units
                    TP 6.0 und ARJ-Archiv
   ------------------------------------------------------------------------

   UNIT config dient zum Einlesen aller Konfigurationsdaten aus der
   Datei SLOTTO.CFG, sowie der Anleitung aus der Datei README.TXT

   READCFG  liest die Konfigurationsdatei
   READANL  liest die Anleitungsdatei

   Ist die Konfigurationsdatei nicht vorhanden oder vollstndig, so wird
   fehler zu TRUE gesetzt und Programm bricht danach ab

   Ist die Anleitungsdatei nicht vorbelegt, so wird darin ein kurzer
   Text vermerkt, da die Datei nicht vorhanden ist, das Programm luft
   jedoch normal weiter. Ist die Datei krzer als die vorgegebene Konstante,
   so werden alle Zeilen leergesetzt.

*)

INTERFACE

USES dos, screen;

CONST
   cfgname = 'SLOTTO.CFG';    (* Name der Konfigurationsdatei *)
   anllang = 69;              (* Lnge der Anleitung in Zeilen *)
   anldat  = 'SLOTTO.DOC';    (* Name der Anleitungsdatei *)


VAR
   gew       : ARRAY[1..10, 1..10] OF LONGINT;    (* Hhe der Gewinne *)
   rechner   : WORD;                              (* Geschwindigkeit  *)

   txt_aus, txt_autostart, txt_untauto, txt_manzie, txt_risiko, txt_menr1,
   txt_menr2, txt_menr3, txt_memr1, txt_memr2, txt_memr3, txt_gewinn1,
   txt_kredit, txt_einsatz, txt_gewinn2, txt_gesetzt, txt_gezogen, txt_zrisiko,
   txt_nixsetzt, txt_nixkredit, txt_ausstop, txt_srisiko, txt_gewan,txt_erfolg,
   txt_verloren, txt_riskende, txt_nixgewinn, txt_setz1, txt_setz2, txt_menh1,
   txt_menh2, txt_menh3, txt_menh4, txt_menh5, txt_menh61, txt_menh62,
   txt_menh7, txt_menh8, txt_memh1, txt_memh2, txt_memh3, txt_memh4, txt_memh5,
   txt_memh61, txt_memh62, txt_memh7, txt_memh8, txt_max, txt_fort,
   txt_ende  : STRING;
   (* Alle im Programm vorkommenden Texte *)

   txt_anl   : ARRAY[1..anllang] OF STRING;      (* Text der Anleitung *)

   ioerg     : INTEGER;         (* Variable zur bernahme von IORESULT *)

   fehler    : BOOLEAN;         (* Variable fr FEHLER bei Dateizugriff *)

PROCEDURE readcfg;
PROCEDURE readanl;

IMPLEMENTATION

VAR
    i,j : BYTE ;   (* Hilfsvariablen fr UNIT-Initialisierung *)

   PROCEDURE readcfg;


   VAR
       txt  : TEXT;    (* Dateivariable fr Text *)
       i, j : BYTE;

      FUNCTION upc(s : STRING) : STRING;
      (* Wandelt einen Text in Grobuchstaben um *)

      VAR
          i : INTEGER;
          e : STRING;

      BEGIN
         e := s ;
         FOR i := 1 TO LENGTH(e)
         DO e[i] := UPCASE(e[i]);
         upc := e;
      END;

      PROCEDURE ereadln(VAR was : STRING);
      (* liest eine Zeile aus einer Textdatei ein *)

      BEGIN
         IF NOT(EOF(txt))
         THEN BEGIN
            READLN(txt, was);
            ioerg := IORESULT;
         END
         ELSE BEGIN
            fehler := TRUE;
            was := '';
            EXIT;
         END;
         (* Ist das Dateiende erreicht, so wird das Lesen bersprungen
            und die Fehlervariable auf TRUE gesetzt *)

         WHILE (COPY(upc(was), 1, 3) = 'REM') AND (NOT EOF(txt))
         DO BEGIN
            IF NOT(EOF(txt))
            THEN BEGIN
               READLN(txt, was);
               ioerg := IORESULT;
            END;
         END;
         (* Solange eine Zeile mit REM beginnt, wird sie berlesen *)

      END;

      PROCEDURE del_bisgleich(VAR was : STRING);
      (* entfernt aus einer Zeile alles bis zum = Zeichen und dann noch
         alle weiteren Leerzeichen *)

      BEGIN
         WHILE was[1] <> '='
         DO DELETE(was, 1, 1);
         DELETE(was, 1, 1);
         WHILE was[1] = ' '
         DO DELETE(was, 1, 1);
      END;

      PROCEDURE lestxt(VAR was : STRING);
      (* Liest eine Zeile ein in der Text stehen mu *)

      BEGIN
         ereadln(was);
         IF fehler
         THEN was := ''
         ELSE BEGIN
            del_bisgleich(was) ;
            was := upc(was);
         END;
      END;

      PROCEDURE lestxtm(VAR was : STRING);
      (* Liest eine Zeile ein ohne Entfernung der fhrenden Zeichen bis = *)

      BEGIN
         ereadln(was);
         IF fehler
         THEN was := '';
      END;

      PROCEDURE lesint(VAR i : WORD);
      (* liest eine Zeile ein, in der eine Zahl stehen mu *)

      VAR
          was : STRING;
          iii : INTEGER;

      BEGIN
         ereadln(was);
         IF fehler
         THEN i := 0
         ELSE BEGIN
            del_bisgleich(was) ;
            VAL(was, i, iii);
            IF iii<>0
            THEN i:=0 ;
         END;
      END;

      PROCEDURE leslongint(VAR i : LONGINT);
      (* liest eine Zeile ein, in der eine LONGINT-Zahl stehen mu *)

      VAR
          was : STRING;
          iii : INTEGER;

      BEGIN
         ereadln(was);
         IF fehler
         THEN i := 0
         ELSE BEGIN
            del_bisgleich(was) ;
            VAL(was, i, iii);
            IF iii<>0
            THEN i:=0 ;
         END;
      END;

   BEGIN (* PROZEDUR READCFG *)
   (*
      Alle Daten der Konfigurationsdatei mssen in der richtigen
      Reihenfolge vorhanden sein, da das Programm sonst abstrzt
   *)

      (*$I-*)
      fehler := FALSE;
      ASSIGN(txt, cfgname);
      ioerg := IORESULT;
      RESET(txt);
      ioerg := IORESULT;
      IF ioerg <> 0
      THEN BEGIN
         fehler := TRUE;
         EXIT;
      END;
      IF (ioerg <> 0) OR EOF(txt)
      THEN BEGIN
         fehler := TRUE;
         EXIT;
      END;
      IF NOT fehler THEN lestxt(schirm);
      IF NOT fehler THEN lesint(msc);
      IF NOT fehler THEN lesint(fs);
      IF NOT fehler THEN lesint(mn);
      IF NOT fehler THEN lesint(mf);
      IF NOT fehler THEN lesint(mr);
      IF NOT fehler THEN lesint(mb);
      IF NOT fehler THEN lesint(mrr);
      IF NOT fehler THEN lesint(mrb);
      IF NOT fehler THEN lesint(mbr);
      IF NOT fehler THEN lesint(mbb);
      IF NOT fehler THEN lesint(mrbr);
      IF NOT fehler THEN lesint(mrbb);
      IF NOT fehler THEN lesint(fn);
      IF NOT fehler THEN lesint(ff);
      IF NOT fehler THEN lesint(fr);
      IF NOT fehler THEN lesint(fb);
      IF NOT fehler THEN lesint(frr);
      IF NOT fehler THEN lesint(frb);
      IF NOT fehler THEN lesint(fbr);
      IF NOT fehler THEN lesint(fbb);
      IF NOT fehler THEN lesint(frbr);
      IF NOT fehler THEN lesint(frbb);
      IF NOT fehler THEN lesint(ln);
      IF NOT fehler THEN lesint(lf);
      IF NOT fehler THEN lesint(lr);
      IF NOT fehler THEN lesint(lb);
      IF NOT fehler THEN lesint(lrr);
      IF NOT fehler THEN lesint(lrb);
      IF NOT fehler THEN lesint(lbr);
      IF NOT fehler THEN lesint(lbb);
      IF NOT fehler THEN lesint(lrbr);
      IF NOT fehler THEN lesint(lrbb);
      FOR j := 1 TO 10
      DO FOR i := 1 TO j
         DO IF NOT fehler THEN leslongint(gew[j, i]);
      IF NOT fehler THEN lesint(rechner);
      IF NOT fehler THEN lestxtm(txt_aus);
      IF NOT fehler THEN lestxtm(txt_autostart);
      IF NOT fehler THEN lestxtm(txt_untauto);
      IF NOT fehler THEN lestxtm(txt_manzie);
      IF NOT fehler THEN lestxtm(txt_risiko);
      IF NOT fehler THEN lestxtm(txt_menr1);
      IF NOT fehler THEN lestxtm(txt_menr2);
      IF NOT fehler THEN lestxtm(txt_menr3);
      IF NOT fehler THEN lestxtm(txt_memr1);
      IF NOT fehler THEN lestxtm(txt_memr2);
      IF NOT fehler THEN lestxtm(txt_memr3);
      IF NOT fehler THEN lestxtm(txt_gewinn1);
      IF NOT fehler THEN lestxtm(txt_kredit);
      IF NOT fehler THEN lestxtm(txt_einsatz);
      IF NOT fehler THEN lestxtm(txt_gewinn2);
      IF NOT fehler THEN lestxtm(txt_gesetzt);
      IF NOT fehler THEN lestxtm(txt_gezogen);
      IF NOT fehler THEN lestxtm(txt_zrisiko);
      IF NOT fehler THEN lestxtm(txt_nixsetzt);
      IF NOT fehler THEN lestxtm(txt_nixkredit);
      IF NOT fehler THEN lestxtm(txt_ausstop);
      IF NOT fehler THEN lestxtm(txt_srisiko);
      IF NOT fehler THEN lestxtm(txt_gewan);
      IF NOT fehler THEN lestxtm(txt_erfolg);
      IF NOT fehler THEN lestxtm(txt_verloren);
      IF NOT fehler THEN lestxtm(txt_riskende);
      IF NOT fehler THEN lestxtm(txt_nixgewinn);
      IF NOT fehler THEN lestxtm(txt_setz1);
      IF NOT fehler THEN lestxtm(txt_setz2);
      IF NOT fehler THEN lestxtm(txt_menh1);
      IF NOT fehler THEN lestxtm(txt_menh2);
      IF NOT fehler THEN lestxtm(txt_menh3);
      IF NOT fehler THEN lestxtm(txt_menh4);
      IF NOT fehler THEN lestxtm(txt_menh5);
      IF NOT fehler THEN lestxtm(txt_menh61);
      IF NOT fehler THEN lestxtm(txt_menh62);
      IF NOT fehler THEN lestxtm(txt_menh7);
      IF NOT fehler THEN lestxtm(txt_menh8);
      IF NOT fehler THEN lestxtm(txt_memh1);
      IF NOT fehler THEN lestxtm(txt_memh2);
      IF NOT fehler THEN lestxtm(txt_memh3);
      IF NOT fehler THEN lestxtm(txt_memh4);
      IF NOT fehler THEN lestxtm(txt_memh5);
      IF NOT fehler THEN lestxtm(txt_memh61);
      IF NOT fehler THEN lestxtm(txt_memh62);
      IF NOT fehler THEN lestxtm(txt_memh7);
      IF NOT fehler THEN lestxtm(txt_memh8);
      IF NOT fehler THEN lestxtm(txt_max);
      IF NOT fehler THEN lestxtm(txt_fort);
      IF NOT fehler THEN lestxtm(txt_ende);
      CLOSE(txt);
      ioerg := IORESULT;
   END;

   PROCEDURE readanl;

   VAR
       i   : INTEGER;
       txt : TEXT;

   BEGIN
      ASSIGN(txt, anldat);
      ioerg := IORESULT;
      RESET(txt);
      ioerg := IORESULT;
      IF (ioerg = 0) AND NOT EOF(txt)
      THEN BEGIN
         FOR i := 1 TO anllang
         DO BEGIN
            IF NOT(EOF(txt))
            THEN BEGIN
               READLN(txt, txt_anl[i]);
               ioerg := IORESULT;
            END;
      END;
      CLOSE(txt);
      ioerg := IORESULT;
      (*$I+*)
   END;
END;

BEGIN
(* Standardvorbelegung aller Konfigurationsangaben *)
FOR j := 1 TO 10
DO FOR i := 1 TO 10
   DO gew[j, i] := 0;
rechner := 1;
txt_aus := 'aus';
txt_autostart [0] := CHAR(0);
txt_untauto [0] := CHAR(0);
txt_manzie [0] := CHAR(0);
txt_risiko [0] := CHAR(0);
txt_menr1 [0] := CHAR(0);
txt_menr2 [0] := CHAR(0);
txt_menr3 [0] := CHAR(0);
txt_memr1 [0] := CHAR(0);
txt_memr2 [0] := CHAR(0);
txt_memr3 [0] := CHAR(0);
txt_gewinn1 [0] := CHAR(0);
txt_kredit [0] := CHAR(0);
txt_einsatz [0] := CHAR(0);
txt_gewinn2 [0] := CHAR(0);
txt_gesetzt [0] := CHAR(0);
txt_gezogen [0] := CHAR(0);
txt_zrisiko [0] := CHAR(0);
txt_nixsetzt [0] := CHAR(0);
txt_nixkredit [0] := CHAR(0);
txt_ausstop [0] := CHAR(0);
txt_srisiko [0] := CHAR(0);
txt_gewan [0] := CHAR(0);
txt_erfolg [0] := CHAR(0);
txt_verloren [0] := CHAR(0);
txt_riskende [0] := CHAR(0);
txt_nixgewinn [0] := CHAR(0);
txt_setz1 [0] := CHAR(0);
txt_setz2 [0] := CHAR(0);
txt_menh1 [0] := CHAR(0);
txt_menh2 [0] := CHAR(0);
txt_menh3 [0] := CHAR(0);
txt_menh4 [0] := CHAR(0);
txt_menh5 [0] := CHAR(0);
txt_menh61 [0] := CHAR(0);
txt_menh62 [0] := CHAR(0);
txt_menh7 [0] := CHAR(0);
txt_memh1 [0] := CHAR(0);
txt_memh2 [0] := CHAR(0);
txt_memh3 [0] := CHAR(0);
txt_memh4 [0] := CHAR(0);
txt_memh5 [0] := CHAR(0);
txt_memh61 [0] := CHAR(0);
txt_memh62 [0] := CHAR(0);
txt_memh7 [0] := CHAR(0);
txt_max [0] := CHAR(0);
txt_fort [0] := CHAR(0);
txt_ende [0] := CHAR(0);
FOR i := 1 TO anllang
DO txt_anl[i] := CHAR(0);
txt_anl[10] := 'Die Datei SLOTTO.DOC ist nicht vorhanden';
END.

