UNIT PCKDTIME;

INTERFACE

USES Dos,Gentypes;

{
  TimeArr = Array of 6 bytes where
    Byte 1 = Month   [ 1 to 12 ]
    Byte 2 = Day     [ 1 to 31 ]
    Byte 3 = Year    [ X to XX ]
    Byte 4 = Hour    [ 1 to 24 ]
    Byte 5 = Minute  [ 0 to 59 ]
    Byte 6= Seconds  [ 0 to 59 ]
}

FUNCTION SameDay(NewTime,OldTime:TimeArr):Boolean;
FUNCTION DateAfter(VAR NewTime,OldTime:TimeArr):Boolean;
FUNCTION DateString(Time:TimeArr):String;
FUNCTION TimeString(Time:TimeArr):String;
PROCEDURE Str_to_Date(S:String; Var Time:TimeArr);
PROCEDURE Str_to_Time(S:String; Var Time:TimeArr);
PROCEDURE SetTime(VAR Time:TimeArr);
PROCEDURE CurrentTime(Var Time:TimeArr);
PROCEDURE CurrentDate(Var Time:TimeArr);
FUNCTION DateFormat(S:String):Boolean;
FUNCTION TimeFormat(S:String):Boolean;

IMPLEMENTATION

FUNCTION SameDay(NewTime,OldTime:TimeArr):Boolean;
Begin
  If (NewTime[1]=OldTime[1]) and
     (NewTime[2]=OldTime[2]) and
     (NewTime[3]=OldTime[3]) then SameDay:=True else SameDay:=False;
End;

FUNCTION DateAfter(VAR NewTime,OldTime:TimeArr):Boolean;
Begin
  DateAfter:=False;
  If NewTime[3]<OldTime[3] then Exit; { Years  }
  If NewTime[1]<OldTime[1] then Exit; { Months }
  If NewTime[2]<OldTime[2] then Exit; { Days   }
  DateAfter:=True;
End;

FUNCTION DateString(Time:TimeArr):String;
VAR S,S1:String[12]; { Keep small for stack } I:Byte;
Begin
  Str(Time[1]:2,S1);
  S:=S1;
  Str(Time[2]:2,S1);
  S:=S+'/'+S1;
  Str(Time[3]:2,S1);
  S:=S+'/'+S1;
  For I:=1 to Length(S) do If S[I]=' ' then S[I]:='0';
  DateString:=S;
End;

FUNCTION TimeString(Time:TimeArr):String;
VAR S,S1:String[12]; { Keep small for stack } I:Byte; Pm:Boolean;
Begin
  Pm:=False;
  If Time[4] in [1..12] then
  Str(Time[4]:2,S1) else
  Begin
    Str(Time[4]-12:2,S1);
    Pm:=True;
  End;
  S:=S1;
  Str(Time[5]:2,S1);
  S:=S+':'+S1;
  Str(Time[6]:2,S1);
  S:=S+':'+S1;
  For I:=1 to Length(S) do If S[I]=' ' then S[I]:='0';
  If pm then S:=S+'pm' else S:=S+'am';
  TimeString:=S;
End;

PROCEDURE Str_to_Date(S:String; Var Time:TimeArr);
Begin
  Time[1]:=Intt(S[1]+S[2]);
  Time[2]:=Intt(S[4]+S[5]);
  Time[3]:=Intt(S[7]+S[8]);
End;

PROCEDURE Str_to_Time(S:String; Var Time:TimeArr);
Begin
  S:=Upper(S);
  Time[4]:=Intt(S[1]+S[2]);
  If S[9]='P' then Time[4]:=Time[4]+12;
  Time[5]:=Intt(S[4]+S[5]);
  Time[6]:=Intt(S[7]+S[8]);
End;

PROCEDURE CurrentTime(VAR Time:TimeArr);
VAR d1,d2,d3,d4:Word;
Begin
  GetTime(d1,d2,d3,d4);
  Time[4]:=d1;
  Time[5]:=d2;
  Time[6]:=d3;
End;

PROCEDURE CurrentDate(Var Time:TimeArr);
VAR d1,d2,d3,d4:Word; S:String[4];
Begin
  GetDate(d1,d2,d3,d4);
  Time[1]:=d2;
  Time[2]:=d3;
  Str(D1:4,S);
  Time[3]:=Intt(S[3]+S[4]);
End;

PROCEDURE SetTime(VAR Time:TimeArr);
Begin
  CurrentDate(Time);
  CurrentTime(Time);
End;

FUNCTION DateFormat(S:String):Boolean;
Begin
  DateFormat:=(S[1] in ['0'..'9']) and
              (S[2] in ['0'..'9']) and
              (S[4] in ['0'..'9']) and
              (S[5] in ['0'..'9']) and
              (S[7] in ['0'..'9']) and
              (S[8] in ['0'..'9']) and
              (S[3]=S[6]) and (S[3] in ['-','/','\']);
End;

FUNCTION TimeFormat(S:String):Boolean;
VAR B:Boolean;
Begin
  B:=(S[1] in ['0','2']) and
     (S[2] in ['0'..'9']) and
     (S[4] in ['0'..'6']) and
     (S[5] in ['0'..'9']) and
     (S[7] in ['0'..'6']) and
     (S[8] in ['0'..'9']);
  If Length(S)>8 then
    If Upper(S[9]+S[10])='AM' then B:=B and True else
    If Upper(S[9]+S[10])='PM' then B:=B and True else B:=False;
  TimeFormat:=B;
End;

End.
