UNIT Menu1;
{$X+,F+,I-,O+}
{ Menu Editor Routines For Overlay }

{ This is a BIG file, mainly because it is VERY important and powerful! :) }

INTERFACE

USES Gentypes,Misc,Files,Modem,MenuGen,Configu,Crt,Dos,Menu2,Mercury;

PROCEDURE MenuEditor;

IMPLEMENTATION

CONST ListType:Boolean=False;
      NoDel:Boolean=False;

PROCEDURE MLimit(VAR S:String; Len,T:Byte; S2:String);
VAR P,I:Byte; C:Char; Z:Boolean;

PROCEDURE UpdateEnd;
VAR X,Y,I:Byte;
Begin
  X:=WhereX;
  Y:=WhereY;
  For I:=P to Length(S) do Print(S[I]);
  Print(#32#32);
  GoXY(X,Y);
End;

LABEL Why;
Begin
  S:=S2; P:=Length(S)+1;
  Print(S);
  Repeat
    C:=Getkey;
    If T=2 then C:=Upcase(C);
    If (C=#8) and (Length(S)>0) and (P>1) then
      Begin
        Delete(S,P-1,1);
        Bs(1);
        Dec(P);
        UpdateEnd;
      End;
    If C=^Y then
      Begin
        Z:=True;
        Why:
        If (P<Length(S)+1) and (S<>'') then For I:=P to Length(S) do Print(S[I]);
        P:=Length(S)+1;
        Del(Length(S));
        S:='';
        Z:=Not Z;
        If Not Z then Goto Why;
      End;
    If (C in [#32..#255]) and (Length(S)<Len) then
      Begin
        Insert(C,S,P);
        UpdateEnd;
        Inc(P);
        If WhereX=80 then GoXY(1,WhereY+1) else GoXY(WhereX+1,WhereY);
      End;
    If (C=#0) and (NextGk) then
      Begin
        C:=Getkey;
        If (C=#75) and (P>1) then
          Begin
            Dec(P);
            Bs(1);
          End;
        If (C=#77) and (P<Length(S)+1) and (S<>'') then
          Begin
            Inc(P);
            If WhereX=80 then GoXY(1,WhereY+1) else GoXY(WhereX+1,WhereY);
          End;
        If (C=#71) and (P>1) then
          Begin
            Bs(P-1);
            P:=1;
          End;
        If (C=#79) and (P<Length(S)+1) and (S<>'') then
          Begin
            For I:=P to Length(S) do Print(S[I]);
            P:=Length(S)+1;
          End;
        If (C=#83) then
          Begin
            Delete(S,P,1);
            UpdateEnd;
          End;
      End;
  Until (C=^M) or (Logoff) or (C=#27);
  If Not NoDel then While S[Length(S)]=#32 do Dec(S[0]);
  If C=#27 then S:=S2;
End;

PROCEDURE EditCommand;
VAR S:String; C:Char; Cmd:Byte;

PROCEDURE ShowCmd;
Begin
  Cls;
  SSC(1); Print('Command: ['); SSC(3); Print(Strr(Cmd));
  SSC(1); Print('/'); SSC(3); Print(Strr(Menu.Commands));
  SSC(1); Println(']');
  CmdKey('A'); Print(' Command Code  : '); SSC(3); Println(MenCmd[Cmd]^.Key);
  CmdKey('B'); Print(' Description   : '); SSC(3); Tran(MenCmd[Cmd]^.Command); Cr;
  CmdKey('C'); Print(' Input         : '); SSC(3); Println(MenCmd[Cmd]^.Input);
  CmdKey('D'); Print(' Data String   : '); SSC(3); Println(MenCmd[Cmd]^.Data);
  CmdKey('E'); Print(' Data String 2 : '); SSC(3); Println(MenCmd[Cmd]^.AfterData);
  CmdKey('F'); Print(' Access        : '); SSC(3); Println(MenCmd[Cmd]^.Access);
  CmdKey('G'); Print(' Hidden        : '); SSC(3); Println(Yn(MenCmd[Cmd]^.Hidden));
  CmdKey('H'); Print(' AutoRun       : '); SSC(3); Println(Yn(MenCmd[Cmd]^.AutoRun));
  CmdKey('I'); Print(' Run Each Loop : '); SSC(3); Println(Yn(MenCmd[Cmd]^.EveryCommand));
  If Menu.PullDown then
    Begin
  CmdKey('J'); Print(' Run on HotKey : '); SSC(3); Println(Yn(MenCmd[Cmd]^.HKlight));
  CmdKey('X'); Print(' Pull Down X   : '); SSC(3); Println(Strr(MenCmd[Cmd]^.Px));
  CmdKey('Y'); Print(' Pull Down Y   : '); SSC(3); Println(Strr(MenCmd[Cmd]^.Py));
  CmdKey('1'); Print(' Command On    : '); SSC(3); Tran(MenCmd[Cmd]^.On); Cr;
  CmdKey('2'); Print(' Command Off   : '); SSC(3); Tran(MenCmd[Cmd]^.Off); Cr;
  CmdKey('3'); Print(' Run on HotKey : '); SSC(3); Println(Yn(Menu.PdHk));
  CmdKey('4'); Print(' Hotkey HL     : '); SSC(3); Println(Yn(Menu.PdHighLight));
    End;
End;

PROCEDURE GetIt(C:Char);
VAR S:String; B,B2:Byte;
Begin
  Cls;
  SSC(1); Print('['); SSC(3); Print('^Y'); SSC(1); Print('] to Erase and [');
  SSC(3); Print('ESC'); SSC(1); Println('] to Abort.');
  Print('New ');
  Case C of
    'A':Print('Command');
    'B':Print('Descripton');
    'C':Print('Input');
    'D':Print('Data String');
    'E':Print('Data String 2');
    'F':Print('Access');
    '1':Print('Command Highlighted');
    '2':Print('Command Not Highlighted');
  End;
  Print(': '); SSC(0);
  If C='A' then B:=3 else
  If C='B' then B:=80 else
  If C='C' then B:=64 else
  If C in ['D','E'] then B:=255 else B:=15;
  If C in ['A','C'] then B2:=2 else B2:=0;
  If C in ['1','2'] then
    Begin
      NoDel:=True;
      B:=80;
      B2:=0;
    End;
  Case C of
    'A':S:=MenCmd[Cmd]^.Key;
    'B':S:=MenCmd[Cmd]^.Command;
    'C':S:=MenCmd[Cmd]^.Input;
    'D':S:=MenCmd[Cmd]^.Data;
    'E':S:=MenCmd[Cmd]^.AfterData;
    'F':S:=MenCmd[Cmd]^.Access;
    '1':S:=MenCmd[Cmd]^.On;
    '2':S:=MenCmd[Cmd]^.Off;
  End;
  MLimit(S,B,B2,S);
  NoDel:=False;
  Case C of
    'A':If S<>'' then MenCmd[Cmd]^.Key:=S;
    'B':MenCmd[Cmd]^.Command:=S;
    'C':MenCmd[Cmd]^.Input:=S;
    'D':MenCmd[Cmd]^.Data:=S;
    'E':MenCmd[Cmd]^.AfterData:=S;
    'F':MenCmd[Cmd]^.Access:=S;
    '1':MenCmd[Cmd]^.On:=S;
    '2':MenCmd[Cmd]^.Off:=S;
  End;
End;

PROCEDURE GetCoord(B:Boolean);
VAR S:String;
Begin
  SSC(1); Print('New ');
  If B then Print('X') else Print('Y');
  Print(' Coordinate: '); SSC(0); Limit(S,2,2); Cr;
  Case B of
    True:If (Intt(S)>0) and (Intt(S)<81) then MenCmd[Cmd]^.Px:=Intt(S);
    False:If (Intt(S)>0) and (Intt(S)<26) then MenCmd[Cmd]^.Py:=Intt(S);
  End;
End;

LABEL Lab,NoPrompt;
Begin
  SSC(1); Print('Command to Edit: '); SSC(0); Limit(S,3,2); Cr;
  Cmd:=Intt(S);
  If (Cmd<1) or (Cmd>Menu.Commands) then Exit;
  Repeat
    ShowCmd;
    Lab:
    Prompt;
    NoPrompt:
    Repeat
      C:=UpCase(Getkey);
    Until (C in ['1'..'4','T','Q','L','+','=','1','-','_','?','A'..'J','X','Y']) or (Logoff);
    Cr;
    If C in ['A'..'F'] then GetIt(C);
    If C='G' then MenCmd[Cmd]^.Hidden:=Not MenCmd[Cmd]^.Hidden;
    If C='H' then MenCmd[Cmd]^.AutoRun:=Not MenCmd[Cmd]^.AutoRun;
    If C='I' then MenCmd[Cmd]^.EveryCommand:=Not MenCmd[Cmd]^.EveryCommand;
    If C='T' then
      Begin
        SSC(1); Println('Data String:'); SSC(3);
        RunData(Cmd,True);
        Cr;
        If WhereX<>1 then Cr;
        SSC(1); Println('After Data String:'); SSC(3);
        RunData(Cmd,False);
        Cr;
        If WhereX<>1 then Cr;
        SSC(1); Print('Output String : '); SSC(3); Println(DataS);
        SSC(1); Print('Output Integer: '); SSC(3); Println(Strr(DataI));
        Getkey;
      End;
    If (C='J') and (Menu.PullDown) then MenCmd[Cmd]^.HKlight:=Not MenCmd[Cmd]^.HKlight else
    If (C='J') then Goto NoPrompt;
    If C='?' then
      Begin
        MenuTop;
        MenuCmd('T','Test Data Strings');
        MenuCmd('+','Forward 1 Command');
        MenuCmd('-','Backwards 1 Command');
        MenuCmd('L','List Command');
        MenuCmd('Q','Quit');
        MenuBottom;
        Goto Lab;
      End;
    If C in ['+','='] then If Cmd=Menu.Commands then Cmd:=1 else Inc(Cmd);
    If C in ['-','_'] then If Cmd=1 then Cmd:=Menu.Commands else Dec(Cmd);
    If Menu.Pulldown then
   Begin
    If C in ['X','Y'] then GetCoord(C='X');
    If C in ['1','2'] then GetIt(C);
    If C='3' then Menu.PdHk:=Not Menu.PdHk;
    If C='4' then Menu.PdHighLight:=Not Menu.PdHighLight;
   End;
  Until (Logoff) or (C='Q');
End;

PROCEDURE List;
VAR I:Integer; B:Byte;
Begin
  Cls;
  If Not ListType then
    Begin
      If Menu.Commands=0 then
        Begin
          SSC(4);
          Print('No commands exist in this menu!');
        End else
        Begin
          MenuTop;
          I:=1;
          Repeat
            ListCmd(I,MenCmd[I]^.Command);
            Inc(I);
          Until (Logoff) or (I=Menu.Commands+1) or (ChWait);
          MenuBottom;
        End;
    End
  else
    Begin
      SSC(1); Print('Menu Name           : '); SSC(3); Println(Menu.Name);
      CmdKey('1'); Println(' Menu Title(s)');
      SSC(3); For I:=1 to 3 do If Menu.Title[I]<>'' then
                Begin
                  If Menu.MidTitle then
                    For B:=1 to (80-TranLen(Menu.Title[I])) div 2 do Print(#32);
                  Tran(Menu.Title[I]);
                  Cr;
                End;
      CmdKey('2'); Print(' Center Titles   : '); SSC(3); Println(Yn(Menu.Midtitle));
      CmdKey('3'); Print(' Ansi File       : '); SSC(3); Println(Menu.AnsiFile);
      CmdKey('4'); Print(' Generic Columns : '); SSC(3); Println(Strr(Menu.Columns));
      CmdKey('5'); Print(' Show Prompt     : '); SSC(3); Println(Yn(Menu.Prompt));
      CmdKey('6'); Print(' Clear Screen    : '); SSC(3); Println(Yn(Menu.Clear));
      CmdKey('7'); Print(' Area String     : '); SSC(3); Tran(Menu.Area); Cr;
      CmdKey('8'); Print(' Error String    : '); SSC(3); Println(Menu.ErrStr);
      CmdKey('9'); Print(' Cr After Input  : '); SSC(3); Println(Yn(Menu.Return));
      CmdKey('#'); Print(' Pull Down Menu  : '); SSC(3); Println(Yn(Menu.PullDown));
      CmdKey('$'); Print(' Draw Commands   : '); SSC(3); Println(Yn(Menu.DrawCmds));
      CmdKey('%'); Print(' Hot Key Input   : '); SSC(3); Println(Yn(Menu.HotKey));
      CmdKey('^'); Print(' Prompt Number   : '); SSC(3); Println(Strr(Menu.PromptN));
      CmdKey('Q'); Println(' Quit');
    End;
End;

PROCEDURE ClrCmd(VAR Cmd:CommandRec);
VAR I:Byte;
Begin
  Cmd.Key:='HLP';
  Cmd.Input:='?';
  Cmd.Command:='|U1[|U0?|U1] |U3Help';
  Cmd.Data:='';
  Cmd.AfterData:='';
  Cmd.Access:='';
  Cmd.Hidden:=False;
  Cmd.AutoRun:=False;
  Cmd.EveryCommand:=False;
  Cmd.HKlight:=True;
  For I:=1 to 6 do Cmd.Flags[I]:=False;
  Cmd.Px:=1;
  Cmd.Py:=1;
  Cmd.On:='';
  Cmd.Off:='';
End;

PROCEDURE AddCommand;
Begin
  If Menu.Commands=MaxMenuCmds then
    Begin
      SSC(4);
      Print('You have reached the command limit!');
      getkey;
      exit;
    End;
  Inc(Menu.Commands);
  New(MenCmd[Menu.Commands]);
  ClrCmd(MenCmd[Menu.Commands]^);
End;

PROCEDURE GetTitles;
VAR S:String; I,B:Byte;
Begin
  For I:=1 to 3 do
    Begin
      SSC(1); Print('Current Title '+Strr(I)+': ');
      Tran(Menu.Title[I]); Cr;
      SSC(1); Print('New Title.  78 Characters Max.'#13': ');
      SSC(0); Limit(S,78,0); Cr;
      Menu.Title[I]:=S;
      If S='' then
        Begin
          If I<3 then For B:=I+1 to 3 do Menu.Title[B]:='';
          Exit;
        End;
    End;
End;

PROCEDURE GetColumns;
VAR C:Char;
Begin
  SSC(1); Print('Number of Columns [');
  SSC(3); Print('1');
  SSC(1); Print('..');
  SSC(3); Print('6');
  SSC(1); Print(']: ');
  SSC(0);
  Repeat C:=Getkey; Until (C in [#13,'1'..'6']);
  If C<>#13 then Menu.Columns:=Intt(C);
End;

PROCEDURE GetArea;
VAR S:String;
Begin
  SSC(1);
  Print('New Area String: '); SSC(0); Limit(S,63,0); Cr;
  If S<>'' then Menu.Area:=S;
End;

PROCEDURE GetErrStr;
Begin
  SSC(1); Print('New Error String: '); SSC(0);
  Limit(Menu.ErrStr,80,0);
End;

PROCEDURE MoveCommand;
VAR Cmd,Dest:Byte; M:CommandRec; S:String;
Begin
  SSC(1); Print('Command to Move: '); SSC(0); Limit(S,2,2); Cr;
  Cmd:=Intt(S);
  If (Cmd<1) or (Cmd>Menu.Commands) then Exit;
  SSC(1); Print('Destination of Command: '); SSC(0); Limit(S,2,2); Cr;
  Dest:=Intt(S);
  If (Dest<1) or (Dest>Menu.Commands) then Exit;
  SSC(1); Print('Moving Command.');
  If Dest=Cmd then Exit;
  M:=MenCmd[Cmd]^;
  DeleteCommand(Cmd);
  If Dest=Menu.Commands+1 then AddCommand else InsertCommand(Dest);
  MenCmd[Dest]^:=M;
End;

PROCEDURE DelCommand;
VAR S:String; Loc:Byte;
Begin
  If Menu.Commands=0 then Exit;
  SSC(1); Print('Command to Delete: '); SSC(0); Limit(S,2,2); Cr;
  Loc:=Intt(S);
  If (Loc<1) or (Loc>Menu.Commands) then Exit;
  DeleteCommand(Loc);
End;

PROCEDURE InsCommand;
VAR S:String; Dest:Byte;
Begin
  SSC(1); Print('Insert Before Which Command: '); SSC(0); Limit(S,2,2); Cr;
  Dest:=Intt(S);
  If (Dest<1) or (Dest>Menu.Commands) then Exit;
  If Menu.Commands=MaxMenuCmds then
    Begin
      SSC(4); Print('You have reached the command limit!'); Getkey;
      Exit;
    End;
  InsertCommand(Dest);
  ClrCmd(MenCmd[Dest]^);
End;

PROCEDURE GetPrompt;
VAR S:String;
Begin
  SSC(1); Print('New Prompt [');
  SSC(3); Print('0/User Prompt');
  SSC(1); Print(']: '); SSC(0); Limit(S,3,0);
  If (S='0') or (Intt(S)>0) then Menu.PromptN:=Intt(S);
End;

PROCEDURE EditCommands;
VAR S,S1:String; C:Char;
LABEL Lab;
Begin
  SSC(1); Print('Menu to Edit: '); SSC(0); Limit(S,8,2); Cr;
  If S='' then Exit;
  If Not ReadCommands(S) then Exit;
  Repeat
    List;
    Lab:
    Prompt;
    Repeat
      C:=UpCase(Getkey);
    Until (Logoff) or (C in ['1'..'9','L','?','Q','X','A','D','P','I','M','S','#','$','%','^']);
    Cr;
    If C='9' then Menu.Return:=Not Menu.Return;
    If C='S' then Begin GenericMenu(Menu.Clear); Goto Lab; End;
    If C='M' then EditCommand;
    If C='1' then GetTitles;
    If C='2' then Menu.MidTitle:=Not Menu.MidTitle;
    If C='3' then
      Begin
        SSC(1); Print('Ansi File Name: ');
        SSC(0); Limit(S1,8,2);
        If S1<>'' then Menu.AnsiFile:=S1;
      End;
    If C='4' then GetColumns;
    If C='^' then GetPrompt;
    If C='%' then Menu.HotKey:=Not Menu.HotKey;
    If C='5' then Menu.Prompt:=Not Menu.Prompt;
    If C='6' then Menu.Clear:=Not Menu.Clear;
    If C='7' then GetArea;
    If C='8' then GetErrStr;
    If C='A' then AddCommand;
    If C='#' then Menu.Pulldown:=Not Menu.Pulldown;
    If C='X' then ListType:=Not ListType;
    If C='P' then MoveCommand;
    If C='D' then DelCommand;
    If C='I' then InsCommand;
    If C='$' then Menu.DrawCmds:=Not Menu.DrawCmds;
    If C='?' then
      Begin
        MenuTop;
        MenuCmd('X','Toggle between command list and menu data list.');
        MenuCmd('M','Edit Command');
        MenuCmd('P','Move Command');
        MenuCmd('A','Add Command');
        MenuCmd('I','Insert Command');
        MenuCmd('D','Delete Command');
        MenuCmd('L','List Commands/Menu Data');
        MenuCmd('S','Show Menu');
        MenuCmd('Q','Quit');
        MenuBottom;
        Goto Lab;
      End;
  Until (C='Q') or (Logoff);
  SSC(1); Print('Save Menu?');
  If YesNo(True,True) then SaveCommands(S) else ClearMenu;
End;

PROCEDURE ListLibraries;
VAR I,B,Z:Integer;
Begin
  SSC(1); Print('['); SSC(3); Print('0'); SSC(1); Print('] [');
  SSC(3); Print('Default Menus');
  If WhereX<>34 then
  For Z:=WhereX to 34 do Print(#32);
  SSC(1); Print('] ['); SSC(3); Print(Sys.MenuDir); SSC(1); Println(']');
  Print('    Access Required: '); SSC(3); Println('No Access Restrictions Allowed!');
  B:=Libraries;
  If B=0 then Exit;
  I:=1;
  Repeat
    LoadLibrary(I);
    SSC(1); Print('[');
    If I>9 then Print(#32);
    SSC(3); Print(Strr(I));
    SSC(1); Print('] [');
    SSC(3); Print(MenuLib^.Name);
    If WhereX<>34 then
    For Z:=WhereX to 34 do Print(#32);
    SSC(1); Print('] [');
    SSC(3); Print(MenuLib^.Location);
    SSC(1); Println(']');
    Print('    Access Required: ');
    SSC(3);
    If MenuLib^.Access='' then Println('No Restrictions') else Println(MenuLib^.Access);
    Inc(I);
  Until (Logoff) or (I=B+1) or (ChWait);
End;

FUNCTION AppendMenuLib:Boolean;
Begin
  AppendMenuLib:=False;
  GetSem(Sys.Datadir+'\MENUS.SEM');
  Assign(LibF,Sys.DataDir+'\MENUS.LIB');
  Reset(LibF);
  If IOresult<>0 then Rewrite(LibF);
  If IOresult<>0 then
    Begin
      ReleaseSem(Sys.DataDir+'\MENUS.SEM');
      Exit;
    End;
  Seek(LibF,FileSize(LibF));
  Write(LibF,MenuLib^);
  Close(LibF);
  ReleaseSem(Sys.DataDir+'\MENUS.SEM');
  AppendMenuLib:=True;
End;

PROCEDURE CreateMenuLib(B:Boolean);
VAR S:String; I:Integer;
Begin
  If B then
    Begin
      SSC(1); Print('Library to Edit: '); SSC(0);
      Limit(S,8,2); Cr;
      I:=Intt(S);
      If (I<1) or (I>Libraries) then Exit;
      If Not LoadLibrary(I) then Exit;
    End;
  SSC(1); Print('Library Name: '); SSC(0);
  Limit(S,30,0);
  If (S='') and (Not B) then Exit;
  If (S='') and (B) then Println(MenuLib^.Name) else
    Begin
      Cr;
      MenuLib^.Name:=S;
    End;
  SSC(1); Print('Directory: '); SSC(0);
  Limit(S,52,2);
  If (S='') and (Not B) then Exit;
  If (S='') and (B) then Println(MenuLib^.Location) else Cr;
  If S<>'' then
    Begin
      MenuLib^.Location:=S;
      ChDir(S);
      If IOresult<>0 then
        Begin
          SSC(4); Println('Directory does not exist!!');
          SSC(1); Print('Create directory now?');
          If YesNo(True,User.YesNoBar) then
            Begin
              Cr;
              MkDir(S);
              If IOresult<>0 then
                Begin
                  USC(4); Println('Error creating director!');
                End else
                Begin
                  Println('Directory has been created!');
                End;
            End else Cr;
        End;
    End;
  ChDir(Sys.MainDir);
  SSC(1); Print('Access Restrictions: '); SSC(0);
  Limit(S,15,0); Cr;
  MenuLib^.Access:=S;
  If Not B then
    Begin
      If Not AppendMenuLib then
        Begin
          SSC(4);
          Print('Error saving library!');
          Getkey;
        End;
    End
  else
    Begin
      If Not SaveLibrary(I) then
        Begin
          SSC(4);
          Print('Error saving library!');
          Getkey;
        End;
    End;
End;

PROCEDURE DeleteMenuLib;
VAR S:String; I:Integer; F:File;
Begin
  SSC(1); Print('Library to Delete: '); SSC(0);
  Limit(S,8,2); Cr;
  I:=Intt(S);
  If (I<1) or (I>Libraries) then Exit;
  If Not LoadLibrary(I) then Exit;
  S:=MenuLib^.Location;
  If Not DeleteLibrary(I) then Exit;
  SSC(1); Print('Delete files in directory?');
  If YesNo(False,User.YesNoBar) then
    Begin
      Cr;
      EraseDir(S+'\*.*');
      SSC(1);
      Print('Delete directory?');
      If YesNo(True,User.YesNoBar) then RmDir(S);
    End;
  SSC(1);
End;

PROCEDURE ListMenus;
VAR Finfo:SearchRec; S,Path:String; I:Integer; B,Z:Byte;
Begin
  Cls;
  SSC(1);
  Print('Library   : '); SSC(3); Println(MenuLib^.Name); SSC(1);
  Print('Directory : '); SSC(3); Println(MenuLib^.Location);
  Cr;
  Path:=MenuLib^.Location+'\*.DAT';
  FindFirst(Path,$00,Finfo);
  B:=DosError;
  If B=0 then
    Begin
      S:=Finfo.Name;
      Dec(S[0],4);
      SSC(1);
      Print('[');
      SSC(3); Print(S);
      If Length(S)<8 then For Z:=Length(S)+1 to 8 do Print(#32);
      SSC(1); Print('] ');
      I:=1;
      Repeat
        FindNext(Finfo);
        B:=DosError;
        If B=0 then
          Begin
            S:=Finfo.Name;
            Dec(S[0],4);
            SSC(1);
            Print('[');
            SSC(3); Print(S);
            If Length(S)<8 then For Z:=Length(S)+1 to 8 do Print(#32);
            SSC(1); Print(']');
            Inc(I);
            If I=7 then
              Begin
                I:=1;
                Cr;
              End else Print(#32);
          End;
      Until (Logoff) or (B<>0);
      If WhereX<>1 then Cr;
    End else
    Begin
      SSC(4);
      Println('There are no menus for this library!');
    end;
  prompt;
End;

PROCEDURE CreateMenu;
VAR S:String; I:Byte;
Begin
  SSC(1); Print('Menu Name: '); SSC(0);
  Limit(S,8,2); Cr;
  If S='' then Exit;
  Menu.Name:=S;
  Menu.Area:=S+' Menu';
  Menu.Title[1]:='|05'+Sys.Name;
  Menu.Title[2]:='|03New Menu';
  Menu.Title[3]:='';
  Menu.MidTitle:=True;
  Menu.Prompt:=True;
  Menu.Clear:=False;
  Menu.Return:=True;
  Menu.PullDown:=False;
  Menu.DrawCmds:=False;
  Menu.HotKey:=False;
  Menu.PdHk:=False; { Run on Hotkey }
  Menu.PdHighLight:=True; { Highlight on Hotkey }
  Menu.ErrStr:='|U4Unrecognized Command!|CR';
  Menu.PromptN:=0;
  Menu.AnsiFile:=S;
  Menu.Columns:=4;
  Menu.Commands:=0;
  SaveMenu(S);
End;

PROCEDURE DeleteMenu;
VAR S:String; F:File;
Begin
  SSC(1); Print('Menu to Delete: '); SSC(0);
  Limit(S,8,2); Cr;
  Assign(F,MenuLib^.Location+'\'+S+'.DAT');
  Erase(F);
  If IOresult<>0 then Exit;
  Assign(F,MenuLib^.Location+'\'+S+'.LST');
  Erase(F);
  If IOresult<>0 then Exit;
End;

PROCEDURE RenameMenu;
VAR F:File;
Begin
End;

PROCEDURE EditMenus;
VAR S:String; C:Char; I:Integer;
LABEL Lab;
Begin
  SSC(1); Print('Library to Edit: '); SSC(0);
  Limit(S,8,2); Cr;
  I:=Intt(S);
  If S='0' then LoadStandard else
    Begin
      If (I<1) and (I>Libraries) then Exit;
      If Not LoadLibrary(I) then Exit;
    End;
  Repeat
    I:=IoResult;
    ListMenus;
    Lab:
    Repeat
      C:=UpCase(GetkEy);
    Until (C in ['D','M','Q','L','?','A','R']) or (Logoff);
    Cr;
    If C='R' then RenameMenu;
    If C='A' then CreateMenu;
    If C='?' then
      Begin
        MenuTop;
        MenuCmd('A','Create New Menu');
        MenuCmd('D','Delete Old Menu');
        MenuCmd('R','Rename Menu');
        MenuCmd('M','Edit Menu');
        MenuCmd('L','List Menus');
        MenuCmd('Q','Quit');
        MenuBottom;
        Prompt;
        Goto Lab;
      End;
    If C='D' then DeleteMenu;
    If C='M' then EditCommands;
  Until (C='Q') or (Logoff);
End;

PROCEDURE InsertMenuLib;
Begin
End;

PROCEDURE MoveMenuLib;
Begin
End;

PROCEDURE MenuEditor;
VAR C:Char; I:Integer;
LABEL Lab;
Begin
  Repeat
  Cls;
  I:=IOresult;
  ListLibraries;
  Lab:
  Prompt;
  Repeat C:=UpCase(GetKey) until (C in ['L','Q','?','A','D','E','M','P','I']) or (Logoff);
  SSC(0); Println(C);
  If C='?' then
    Begin
      MenuTop;
      MenuCmd('A','Create New Library');
      MenuCmd('D','Delete Old Library');
      MenuCmd('I','Insert Library');
      MenuCmd('P','Move Library');
      MenuCmd('E','Edit Library Stats');
      MenuCmd('M','Edit Menus');
      MenuCmd('L','List Libraries');
      MenuCmd('Q','Quit');
      MenuBottom;
      Goto Lab;
    End;
  If C='A' then CreateMenuLib(False);
  If C='E' then CreateMenuLib(True);
  If C='D' then DeleteMenuLib;
  If C='I' then InsertMenuLib;
  If C='P' then MoveMenuLib;
  If (C='M') and (Libraries>0) then EditMenus;
  Until (C='Q') or (Logoff);
  LoadStandard;
End;

End.
