PROGRAM Install;
{$M 5120,0,0}
{$I-,X+}

USES Crt,Dos;

TYPE
  TimeArr = Array[1..6] of Byte;

  ColorArray = Array [0..8] of
    Record
      Fore,Back:Byte;
    End;
  StatusRec = Record
    Name      : String;
    SysOp     : String;
    Number    : String[15];
    MainDir   : String;
    DataDir   : String;
    FilesDir  : String;
    MsgDir    : String;
    AnsiDir   : String;
    MenuDir   : String;
    WorkDir   : String;
    BaudRate  : Word;
    ComPort   : Byte;
    DataBits  : Byte;
    Parity    : Char;
    StopBits  : Byte;
    UseFossil : Boolean;
    Bios      : Boolean;
    LastWin   : Boolean;
    Colors    : ColorArray;
    SnowChecking   : Boolean;
    MaxWaitingMail : Integer;
    LogonTries     : Byte;
    BlankMins      : Byte;
    ChatAttempts   : Byte;
    SoundSource    : Byte;
    ModSpeed       : Integer; { 1193182 div Rate }
    MaxMsgLength   : Word;
    ManualAnswer   : Boolean;
    SpecialEffects : Boolean;
    OverlayEMS     : Boolean;
    PointChecking  : Boolean;
    RatioChecking  : Boolean;
    OffHookLogon   : Boolean;
    UseRumors      : Boolean;
    UseTheWall     : Boolean;
    LockComPort    : Boolean;
    StatusLine     : Boolean;
    Matrixes       : Byte;
    CompressNums   : Boolean;
    Fill           : Array[1..3] of Byte;
    TotalFiles     : Word;
    TotalPosts     : Word;
    NewUserPassword: String;
    SwaponShell    : Boolean;
    SystemPassword : String;
    BaudSupported  : Array [1..7] of Boolean;
    LockOutPassword: String;
    FPCredit       : Byte;
    DeletionVotes  : Byte;
    NewUserSL      : Byte;
    NewUserDSL     : Byte;
    BarOnFore      : Byte;
    BarOnBack      : Byte;
    BarOffFore     : Byte;
    BarOffBack     : Byte;
    PauseType      : Byte; { 1:at 1,24 2:at current spot 3:no string }
    InfoForms      : Array [1..5] of Record
      Name         : String[30];
      Required     : Boolean;
      Permanent    : Boolean;
    End;
    NodeNumber     : Integer;
    NodeType       : (MainNode,SecondaryNode,LocalNode);
    MultiNodes     : Boolean;
    FallBackMenu   : String[8];
    MainNodeDir    : String[75];
    MessageLen     : Integer;
    NewUsers       : Word;
    YesVotes       : Byte;
    NoVotes        : Byte;
    Nodes          : Integer;
    LastUpdate     : TimeArr;
    KupToday       : Integer;
    KdownToday     : Integer;
    PostsToday     : Integer;
  End;

VAR C:Char; S:String; Port:Byte; Sys:StatusRec;

FUNCTION Intt(S:String):Integer;
VAR Temp,Code:Integer;
Begin
  If Length(S)=0 then Intt:=0 else
    Begin
      Val(S,Temp,Code);
      If Code=0 then Intt:=Temp else Intt:=0;
    End;
End;

FUNCTION Exist(S:String):Boolean;
VAR Fn:SearchRec; I:Integer;
Begin
  I:=DosError;
  FindFirst(S,AnyFile,Fn);
  Exist:=(DosError=0);
End;

PROCEDURE Run(S,S1:String);
VAR Color:Word;
Begin
  Color:=TextAttr;
  TextAttr:=0;
  SwapVectors;
  Exec(GetEnv('COMSPEC'),+'/C '+S+#32+S1+' -O > NUL');
  SwapVectors;
  TextAttr:=Color;
End;

PROCEDURE MakeStatus;
VAR I:Byte; F:File of StatusRec;
Begin
  Writeln('Creating STATUS.DAT!');
  Sys.Name:='OTERA BBS';
  Sys.SysOp:='OTERA SysOp';
  Sys.Number:='(900) 666-6969';
  Sys.MainDir:=S;
  Sys.DataDir:=S+'\DATA';
  Sys.FilesDir:=S+'\FILES';
  Sys.MsgDir:=S+'\MSGS';
  Sys.AnsiDir:=S+'\ANSI';
  Sys.MenuDir:=S+'\MENUS';
  Sys.WorkDir:=S+'\WORK';
  Sys.BaudRate:=38400;
  Sys.ComPort:=Port;
  Sys.DataBits:=8;
  Sys.StopBits:=1;
  Sys.Parity:='N';
  Sys.UseFossil:=True;
  Sys.Bios:=False;
  Sys.LastWin:=True;
  Sys.Colors[0].Fore:=15;
  Sys.Colors[0].Back:=0;
  Sys.Colors[1].Fore:=8;
  Sys.Colors[1].Back:=0;
  Sys.Colors[2].Fore:=5;
  Sys.Colors[2].Back:=0;
  Sys.Colors[3].Fore:=7;
  Sys.Colors[3].Back:=0;
  Sys.Colors[4].Fore:=12;
  Sys.Colors[4].Back:=0;
  Sys.Colors[5].Fore:=13;
  Sys.Colors[5].Back:=0;
  Sys.Colors[6].Fore:=11;
  Sys.Colors[6].Back:=0;
  Sys.Colors[7].Fore:=7;
  Sys.Colors[7].Back:=0;
  Sys.Colors[8].Fore:=3;
  Sys.Colors[8].Back:=0;
  Sys.SnowChecking:=False;
  Sys.MaxWaitingMail:=50;
  Sys.LogonTries:=0;
  Sys.BlankMins:=5;
  Sys.ChatAttempts:=5;
  Sys.SoundSource:=4;
  Sys.ModSpeed:=99;
  Sys.MaxMsgLength:=512;
  Sys.ManualAnswer:=True;
  Sys.SpecialEffects:=True;
  Sys.OverlayEMS:=True;
  Sys.PointChecking:=True;
  Sys.RatioChecking:=True;
  Sys.OffHookLogon:=True;
  Sys.UseRumors:=True;
  Sys.UseTheWall:=True;
  Sys.LockComPort:=True;
  Sys.StatusLine:=True;
  Sys.Matrixes:=2;
  Sys.CompressNums:=True;
  Sys.Fill[1]:=0;
  Sys.Fill[2]:=0;
  Sys.Fill[3]:=0;
  Sys.TotalFiles:=0;
  Sys.TotalPosts:=0;
  Sys.NewUserPassword:='';
  Sys.SwaponShell:=True;
  Sys.SystemPassword:='OTERA BBS';
  For I:=1 to 7 do Sys.BaudSupported[I]:=True;
  Sys.LockOutPassword:='Scha Right!';
  Sys.FpCredit:=3;
  Sys.DeletionVotes:=10;
  Sys.NewUserSl:=10;
  Sys.NewUserDsl:=10;
  Sys.BarOnFore:=15;
  Sys.BarOnBack:=4;
  Sys.BarOffFore:=15;
  Sys.BarOffBack:=0;
  Sys.PauseType:=2;
  FillChar(Sys.InfoForms,SizeOf(Sys.InfoForms),#0);
  Sys.NodeNumber:=1;
  Sys.NodeType:=MainNode;
  Sys.MultiNodes:=False;
  Sys.FallBackMenu:='MAIN';
  Sys.MainNodeDir:=S;
  Sys.MessageLen:=512;
  Sys.NewUsers:=0;
  Sys.YesVotes:=10;
  Sys.NoVotes:=10;
  Sys.Nodes:=0;
  FillChar(Sys.LastUpdate,6,#0);
  Sys.KupToday:=0;
  Sys.KdownToday:=0;
  Sys.PostsToday:=0;
  Assign(F,S+'\STATUS.DAT');
  Rewrite(F);
  Write(F,Sys);
  Close(F);
End;

PROCEDURE Upgrade;
Begin
  Writeln('Installing New Ansi Files.');
  MkDir(S+'\ANSI');
  Run('PKUNZIP','ANSIUP.ZIP '+S+'\ANSI');
  Writeln('Installing New Data Files.');
  MkDir(S+'\DATA');
  Run('PKUNZIP','DATAUP.ZIP '+S+'\DATA');
  Writeln('Installing New Main Directory Files.');
  Run('PKUNZIP','MAINUP.ZIP '+S);
  Writeln('Installing New Menu Upgrade Files.');
  MkDir(S+'\MENUS');
  Run('PKUNZIP','MENUUP.ZIP '+S+'\MENUS');
End;

PROCEDURE InstallNew;
Begin
  MakeStatus;
  Writeln('Installing Upgrade Files...');
  Upgrade;
  Writeln('Installing Main Ansi Files.');
  Run('PKUNZIP','ANSINEW.ZIP '+S+'\ANSI');
  Writeln('Installing Main Data Files.');
  Run('PKUNZIP','DATANEW.ZIP '+S+'\DATA');
  Writeln('Installing Main Files.');
  Run('PKUNZIP','MAINNEW.ZIP '+S);
  Writeln('Installing Main Menu Files.');
  Run('PKUNZIP','MENUNEW.ZIP '+S+'\MENUS');
  Writeln('Installing Pull-Down Menus.');
  MkDir(S+'\PULLDOWN');
  MkDir(S+'\FHACKSET');
  MkDir(S+'\FILES');
  MkDir(S+'\MSGS');
  MkDir(S+'\NET');
  MkDir(S+'\WORK');
  Run('PKUNZIP','PULLDOWN.ZIP '+S+'\PULLDOWN');
End;

Begin
  ClrScr;
  Writeln('OTERA(c) Installation Program v1.0');
  Writeln('Copyright 1993 Power Systems Inc.');
  Writeln('All Rights Reserved.');
  Writeln;
  Writeln('[1] Install New System');
  Writeln('[2] Upgrade from eta #4');
  Writeln('[Q] Abort Installation');
  Writeln('[N] Create New STATUS.DAT');
  Writeln;
  Write('Command: ');
  Repeat C:=Upcase(Readkey) Until C in ['1','2','Q','N'];
  Writeln(C);
  If C='Q' then Halt(1);
  Case C of
    '1':Writeln('Installing New Version...');
    '2':Writeln('Upgrading to eta #5...');
    'N':Writeln('Creating New STATUS.DAT...');
  End;
  Write('Main Directory: '); Readln(S);
  If S='' then Halt(1);
  If Not Exist(S) then MkDir(S);
  While S[Length(S)]='\' do Dec(S[0]);
  Write('Comport [1..4]: ');
  Repeat Port:=Intt(Readkey) Until Port in [1..4];
  Writeln(Port);
  Case C of
    '1':InstallNew;
    '2':Begin
          Upgrade;
          Writeln;
          Writeln('Be sure to run UPGRADE.EXE!');
        End;
    'N':MakeStatus;
  End;
End.
