(*

 Ŀ               OTERA(c) BBS PROGRAM                           
          Ŀ Ŀ Ŀ Ŀ                            
       Ŀ            Driver Routines        
  Ŀ  Ŀ   Ŀ  Ŀ Ŀ                              
          Ŀ  Ŀ         CopyRight 1992-1993      
                                                            
                  Ŀ  Power Systems Inc.  
                                


         This program was written to interface with the current versions of
BNU and X00.  This has not been tested with any versions of eigther of these
two programs released after January 1, 1993.

------------------------------------------------------------------------------
Current Fossil Driver Functions as of July 30, 1992:
------------------------------------------------------------------------------
| Num | Description                                                          |
------------------------------------------------------------------------------
| $00 | Set Modem Speed (Locking) You can find Baud Rate data in Unit        |
| $01 | Raise Data Terminal Ready Line to Higher Frequency                   |
| $02 | Read Character from the Fossil Buffer (If available)                 |
| $03 | Check for Carrier                                                    |
| $04 | Initialize Fossil Driver                                             |
| $05 | Dissable Fossil Driver                                               |
| $06 | Lower Data Terminal Ready Line (Causes most modems to hang up)       |
| $08 | Clear the OutPut Buffer Function                                     |
| $0A | Clear Input Buffer Function                                          |
| $0C | Return Number of Characters in Input Buffer ($FFFF Means None)       |
| $0F | Set Data/Parity/Stop Bits Function (Standard is 8N1 or $F0)          |
------------------------------------------------------------------------------
*)
UNIT Fossil;
{$X+}

INTERFACE

USES Dos,Crt;

CONST
  FossilPort:Word=1;
  FossilInstalled:Boolean=False;

FUNCTION OpenCom(ComPort:Byte):Boolean;
PROCEDURE SetModemParams(Baud,DataBits:Word; Parity:Char; StopBits:Word);
FUNCTION Carrier:Boolean;
FUNCTION CharsWaiting:Boolean;
FUNCTION OutPutEmpty:Boolean;
FUNCTION GetChar:Char;
FUNCTION FossilName:String;
PROCEDURE Set_Flow_Control(State:Byte);
PROCEDURE Disconnect(S:String);
PROCEDURE DeinstallModem;
PROCEDURE LowerDtr;
PROCEDURE RaiseDtr;
PROCEDURE ClrOutPut;
PROCEDURE ClrInPut;
PROCEDURE SendChar(C:Char);
PROCEDURE SendString(S:String);
PROCEDURE SendBlock(Seg_ment,Off_set,Count:Word);
PROCEDURE ReadBlock(Seg_ment,Off_set,Count:Word);

IMPLEMENTATION
(*
PROCEDURE Bypass; External;
PROCEDURE TPX00(Var Regs:Registers); External;
{$L TPX00}
*)
CONST
  MaxPort=4;            { Maximum Ports supported by current Fossil Drivers }

TYPE
     Fossil_StructRec = Record
         StructSize : Word;
         MajorVer   : Byte;
         MinVer     : Byte;
         FOS_ID     : Array [1..2] of Word;
         Inp_Buffer : Word;
         Recv_Bytes : Word;
         Out_Buffer : Word;
         Send_Bytes : Word;
         SWidth     : Byte;
         SHeight    : Byte;
         BaudRate   : Byte
       End;

VAR
  OldExit:Pointer;
  Regs:Registers;
  Fossil_Struct:Fossil_StructRec;

FUNCTION OpenCom(ComPort:Byte):Boolean;
Begin
  If Not (ComPort in [1..MaxPort]) then
    Begin
      OpenCom:=False;
      Exit;
    End;
  Regs.Ah:=$04;                 { Create Fossil Interrupt Function }
  FossilPort:=ComPort-1;
  Regs.Dx:=FossilPort;
  Intr($14,Regs); (* TPX00(Regs); *)
  If (Regs.Ax=$1954) then FossilInstalled:=True else
    Begin
      OpenCom:=False;
      FossilInstalled:=False;
      FossilPort:=0;
    End;
End;

PROCEDURE SetModemParams(Baud,DataBits:Word; Parity:Char; StopBits:Word);
Begin
  Case Baud of
    300:Baud:=96;
    1200:Baud:=128;
    2400:Baud:=160;
    4800:Baud:=192;
    9600:Baud:=224;
    19200:Baud:=0;
    38400:Baud:=32;
  End;
  Case DataBits of
    7:Baud:=Baud+2;
    8:Baud:=Baud+3;
  End;
  Case Upcase(Parity) of
    'N':Baud:=Baud+0;
    'E':Baud:=Baud+8;
    'O':Baud:=Baud+24;
  End;
  Case StopBits of
    1:Baud:=Baud+0;
    1:Baud:=Baud+4;
  End;
  Regs.Ah:=$00;
  Regs.Al:=Baud;
  Regs.Dx:=FossilPort;
  Intr($14,Regs); (* TPX00(Regs); *)
End;

FUNCTION Carrier:Boolean;
Begin
  Regs.Ah:=$03;         { Carrier Function }
  Regs.Dx:=FossilPort;
  Intr($14,Regs); (* TPX00(Regs); *)
  If (Regs.Ax and $0080)=0 then Carrier:=False else Carrier:=True;
End;

FUNCTION CharsWaiting:Boolean;
Begin
  Regs.Dx:=FossilPort;
  Regs.Ah:=$0C;                 { Check Input Function }
  Intr($14,Regs); (* TPX00(Regs); *)
  CharsWaiting:=(Regs.Ax<>$FFFF);
End;

FUNCTION OutPutEmpty:Boolean;
Begin
  Regs.Dx:=FossilPort;
  Regs.Ah:=$03;                 { Check OutPut Function }
  Intr($14,Regs); (* TPX00(Regs); *)
  OutPutEmpty:=((Regs.Ax and $4000)<>0);
End;

FUNCTION GetChar:Char;
Begin
  If Not CharsWaiting then GetChar:=#0 else
    Begin
      Regs.Ah:=$02;                     { Read Char from Buffer Function }
      Regs.Dx:=FossilPort;
      Intr($14,Regs); (* TPX00(Regs); *)
      GetChar:=Chr(Regs.Al);
    End;
End;

PROCEDURE Set_Flow_Control(State:Byte);
Begin
  Regs.Ah:=$0F;         { 1=None, 5=Xon/Xoff, 2=CTS/RTS }
  Regs.Al:=State;
  Regs.Dx:=FossilPort;
  Intr($14,Regs); (* TPX00(Regs); *)
End;

PROCEDURE Disconnect(S:String);
Begin
  If Not Carrier then Exit;
  LowerDtr;
  Delay(700);
  RaiseDtr;
  SendString('+++'+S+^M);
End;

FUNCTION FossilName:String;
VAR First,Second:Word; C:Char; S:String;
Begin
  Regs.Ah:=$1B;
  Regs.Dx:=FossilPort;
  Regs.Es:=Seg(Fossil_Struct);
  Regs.Di:=Ofs(Fossil_Struct);
  Regs.Cx:=SizeOf(Fossil_Struct);
  Intr($14,Regs); (* TPX00(Regs); *)
  First:=Fossil_Struct.FOS_ID[2];
  Second:=Fossil_Struct.FOS_ID[1];
  S:='';
  C:=#26;
  While C<>#0 Do Begin
    C:=Chr(Mem[First:Second]);
    S:=S+C;
    Second:=Second+1;
  End;
  Dec(S[0]);
  FossilName:=S
End;

PROCEDURE DeinstallModem;
Begin
  FossilInstalled:=False;
  Regs.Ah:=$05;                 { Remove Fossil Interrupt Function }
  Regs.Dx:=FossilPort;
  Intr($14,Regs); (* TPX00(Regs); *)
  FossilPort:=0;
End;

PROCEDURE LowerDtr;
Begin
  Regs.Ah:=$06;                 { Lower DTR Function }
  Regs.Dx:=FossilPort;
  Regs.Al:=$00;
  Intr($14,Regs); (* TPX00(Regs); *)
End;

PROCEDURE RaiseDtr;
Begin
  Regs.Ah:=$06;                 { Raise DTR Fuction }
  Regs.Dx:=FossilPort;
  Regs.Al:=$01;
  Intr($14,Regs); (* TPX00(Regs); *)
End;

PROCEDURE ClrOutPut;
Begin
  Regs.Ah:=$09;         { Clear Output Function }
  Regs.Dx:=FossilPort;
  Intr($14,Regs); (* TPX00(Regs); *)
  { Function commented out due to a problem it is causing in OTERA. }
End;

PROCEDURE ClrInPut;
Begin
  Regs.Ah:=$0A;         { Clear Input Function }
  Regs.Dx:=FossilPort;
  Intr($14,Regs); (* TPX00(Regs); *)
End;

PROCEDURE SendChar(C:Char);
Begin
  Regs.Ah:=$01;                 { Send Char Function }
  Regs.Dx:=FossilPort;
  Regs.Al:=Ord(C);
  Intr($14,Regs); (* TPX00(Regs); *)
End;

PROCEDURE SendString(S:String);
VAR I:Byte;
Begin
  For I:=1 to Length(S) do SendChar(S[I]);
End;

PROCEDURE SendBlock(Seg_ment,Off_set,Count:Word);
Begin
  Asm
    mov   es,Seg_ment
@1: mov   cx,Count
    mov   ah,19h
    mov   di,Off_set
    mov   dx,FossilPort
    int   14h
    sub   Count,ax
    add   Off_set,ax
    cmp   Count,0
    jnz   @1
  End;
End;

PROCEDURE ReadBlock(Seg_Ment,Off_Set,Count:Word);
VAR Regs:Registers;
Begin
  Regs.Es:=Seg_Ment;
  While Count>0 do
    Begin
      Regs.Ah:=$18;
      Regs.Di:=Off_Set;
      Regs.Cx:=Count;
      Regs.Dx:=FossilPort;
      Intr($14,Regs); (* TPX00(Regs); *)
      Count:=Count-regs.ax;
      Off_Set:=Off_set+Regs.Ax;
    End;
End;

{$F+}
PROCEDURE MyExit;
Begin
  DeInstallModem;
  ExitProc:=OldExit;
End;
{$F+}

Begin
  OldExit:=ExitProc;
  ExitProc:=@MyExit;
End.
