UNIT Files;
{ Files Access Routines }
{$X+,I-,O+,F+}
INTERFACE

USES
Crt,Dos,Mercury,Modem,Fossil,Misc,Users,Online,BcShare,Configu,PckdTime,
gentypes;

FUNCTION RunObject:Boolean;
FUNCTION ShowForm(I:Byte):Boolean;
FUNCTION GetInfoForm(I:Byte):Word; { Returns position of InfoForm Data }
FUNCTION Add2Voting(I:Word):Word;
PROCEDURE NewUserVoting;
FUNCTION CopyFile(Name,OldDir,NewDir:String):Boolean;
PROCEDURE OpenSystemLogs;
PROCEDURE AddtoSystemLogs(S:String);
FUNCTION UserOnLine(B:Integer):Boolean;
FUNCTION NodeLocation(B:Integer):String;
PROCEDURE UpdateOnline(Loc:String);
PROCEDURE UsersOnline(Format:String);
PROCEDURE ChatMultiNode;
PROCEDURE UserOffNode;
PROCEDURE LoggingOnNode;
FUNCTION SaveStatus:Boolean;
FUNCTION SaveStrings:Boolean;
FUNCTION LoadStrings:Boolean;
FUNCTION LoadScreen(I:Integer):Boolean;
PROCEDURE ReadDataFiles;
FUNCTION AutoDetect:Emulation_Set;
FUNCTION SendInitString:Boolean;
FUNCTION DisplayFont(I:LongInt):Boolean;
PROCEDURE EraseDir(Dir:String);
PROCEDURE Pause;
PROCEDURE TheWall;
PROCEDURE ListActiveNodes;
PROCEDURE ForumEditor;
FUNCTION LoadConference(I:Integer):Boolean;
PROCEDURE CloseIt;
FUNCTION OpenConference(Mode:Byte):Boolean;
PROCEDURE ClearForum;
PROCEDURE GotoConference;
PROCEDURE ReadScript(S:String);
PROCEDURE RegisterMessage;

IMPLEMENTATION

TYPE NodeRec = Record
       Alias : String;
       From  : String;
       Location : String;
     End;

VAR VFile:File;

FUNCTION RunObject:Boolean;
VAR F:File; L:Integer; P:Pointer;
Begin
  RunObject:=False;
  If DataS='' then Exit;
  If Not Exist(DataS) then Exit;
  Assign(F,DataS);
  Reset(F,1);
  If IOresult<>0 then Exit;
  GetMem(P,FileSize(F));
  BlockRead(F,P^,FileSize(F),L);
  If L=FileSize(F) then
    Asm
      Call P
    End;
  FreeMem(P,FileSize(F));
  Close(F);
  RunObject:=True;
End;

FUNCTION OpenV(Mode:Byte; S:String):Boolean;
Begin
  OpenV:=False;
  Assign(Vfile,S);
  SetFileMode(Mode);
  If Not Exist(S) then
    Begin
      Repeat
        Rewrite(Vfile,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until (Ignore<>5);
    End else
    Begin
      Repeat
        Reset(Vfile,1);
        Ignore:=IOresult;
        If Ignore=5 then Delay(300);
      Until (Ignore<>5);
    End;
  SetFileMode(NormalMode);
  If Ignore=0 then OpenV:=True;
  Repeat Until IOresult=0;
End;

PROCEDURE CloseV;
Begin
  Close(Vfile);
  Repeat Until IOresult=0;
End;

FUNCTION WriteV(Nuv:NuvRec):Boolean;
Begin
  WriteV:=False;
  Repeat
    BlockWrite(Vfile,Nuv,SizeOf(Nuv));
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until (Ignore<>5);
  If Ignore=0 then WriteV:=True;
End;

FUNCTION ReadV(VAR Nuv:NuvRec):Boolean;
VAR L:Integer;
Begin
  ReadV:=False;
  Repeat
    BlockRead(Vfile,Nuv,SizeOf(Nuv),L);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until (Ignore<>5);
  If (Ignore=0) and (L=SizeOf(Nuv)) then ReadV:=True;
End;

FUNCTION Vwrite(S:String):Boolean;
Begin
  Repeat
    BlockWrite(Vfile,S,81);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until (Ignore<>5);
  Vwrite:=(Ignore=0);
End;

FUNCTION Vstring(B:Byte):String;
VAR S:String; L:Integer;
Begin
  Seek(Vfile,B*81);
  Repeat
    BlockRead(Vfile,S,81,L);
    Ignore:=IOresult;
    If Ignore=5 then Delay(300);
  Until (Ignore<>5);
  If (Ignore=0) and (L=81) then Vstring:=S else Vstring:='';
End;

PROCEDURE NewUserVoting;
VAR Total:Integer; B:Integer; I:Byte; S:String; Z:Boolean; U:UserRec; C:Char;
    X:Byte;
Begin
  If Not OpenV(ReadDenyNone,Sys.DataDir+'\NUV.DAT') then Exit;
  New(Nuv);
  Total:=FileSize(Vfile) div SizeOf(Nuv^);
  CloseV;
  If Total=0 then
    Begin
      Dispose(Nuv);
      Exit;
    End;
  B:=1;
  Repeat
    OpenV(ReadDenyNone,Sys.DataDir+'\NUV.DAT');
    Seek(Vfile,(B-1)*SizeOf(Nuv^));
    ReadV(Nuv^);
    CloseV;
    Z:=False;
    If Nuv^.Users<>0 then For I:=1 to Nuv^.Users do
      If Nuv^.User[I]=User.Number then
        Begin
          Z:=True;
          X:=I;
        End;
    If (Not Nuv^.Deleted) and (Upper(User.Alias)=Upper(Nuv^.Alias)) then
      Begin
        Show('NUV',False,False);
        Pause;
      End else
    If (Not Nuv^.Deleted) and (Z) and
       (Upper(User.Alias)<>Upper(Nuv^.Alias)) then
      Begin
        Show('NUV',False,False);
        Tran('|U1Voted: |U3'+Yn(Nuv^.Voted[X]=1));
        Cr;
        Tran(Strings^.Fill[22]);
        Repeat C:=Upcase(Getkey); Until C in ['Y','N',^M];
        Case C of
          'Y':Println('Yes');
          'N',^M:Println('No');
        End;
        If C='Y' then
          Begin
            SSC(1);
            If Nuv^.Voted[X]=1 then
              Begin
                Inc(Nuv^.NoVotes);
                Dec(Nuv^.YesVotes);
                Nuv^.Voted[X]:=2;
              End else
              Begin
                Inc(Nuv^.YesVotes);
                Dec(Nuv^.NoVotes);
                Nuv^.Voted[X]:=1;
              End;
            Println('Vote Changed to '+Yn(Nuv^.Voted[X]=1)+'.');
            Pause;
            OpenV(WriteDenyNone,Sys.DataDir+'\NUV.DAT');
            Seek(Vfile,(B-1)*SizeOf(Nuv^));
            WriteV(Nuv^);
            CloseV;
          End;
      End else
    If (Not Nuv^.Deleted) and (Not Z) and
        (Upper(User.Alias)<>Upper(Nuv^.Alias)) then
      Begin
        SSC(1);
        Println(Nuv^.Alias);
        I:=User.Form[5];
        User.Form[5]:=Nuv^.InfoForm;
        If Not ShowForm(5) then
          Begin
            SSC(4);
            Println('User does not have an infoform.');
          End;
        User.Form[5]:=I;
        Show('NUV',False,False);
        Tran(Strings^.Fill[21]);
        Repeat
          C:=Upcase(Getkey);
        Until (C in ['A','Y','N']) or (Logoff);
        Case C of
          'Y':Inc(Nuv^.YesVotes);
          'N':Inc(Nuv^.NoVotes);
        End;
        Case C of
          'Y':Println('Yes');
          'N':Println('No');
          'A':Println('Abstain');
        End;
        If C in ['Y','N'] then
          Begin
            Inc(Nuv^.Users);
            Case C of
              'Y':Nuv^.Voted[Nuv^.Users]:=1;
              'N':Nuv^.Voted[Nuv^.Users]:=2;
            End;
            Nuv^.User[Nuv^.Users]:=User.Number;
          End;
        If C<>'A' then
       Begin
        I:=0;
        Repeat
          Inc(I);
        Until (I=10) or (Nuv^.Comments[I]='');
        If Nuv^.Comments[I]='' then
          Begin
            SSC(1); Print('Leave a Comment?'); Z:=YesNo(False,User.YesNoBar); Cr;
            If Z then
              Begin
                SSC(1);
                Print('Comment: ');
                SSC(0); Limit(S,80,0);
                Cr;
                Nuv^.Comments[I]:=S;
              end;
          End;
       End;
        If Nuv^.YesVotes=Sys.YesVotes then
          Begin
            If LoadUser(Nuv^.Number,U) then
              Begin
                SSC(1);
                ValidateUser(U,2);
                If SaveUser(Nuv^.Number,U) then Println('User Validated!');
              End;
            Nuv^.Deleted:=True;
          End else
        If Nuv^.NoVotes=Sys.NoVotes then
          Begin
            If LoadUser(Nuv^.Number,U) then
              Begin
                SSC(1);
                U.Deleted:=True;
                If SaveUser(Nuv^.Number,U) then Println('User Deleted!');
              End;
            Nuv^.Deleted:=True;
          End;
        If C<>'A' then
          Begin
            OpenV(WriteDenyNone,Sys.DataDir+'\NUV.DAT');
            Seek(Vfile,(B-1)*SizeOf(Nuv^));
            WriteV(Nuv^);
            CloseV;
          End;
      End;
    Inc(B);
  Until (B>Total) or (Logoff);
  Dispose(Nuv);
End;

FUNCTION ShowForm(I:Byte):Boolean;
VAR F:File; S:String; L:Integer; B:Integer; Z:Word;
LABEL Done;
Begin
  ShowForm:=False;
  S:=Sys.AnsiDir+'\INFOFORM.'+Strr(I);
  If Not Exist(S) then Exit;
  New(Data);
  SetFileMode(NormalMode);
  Assign(F,S);
  Reset(F,1);
  BlockRead(F,Data^,SizeOf(Data^),L);
  Close(F);
  If L=0 then Goto Done;
  If Not OpenV(ReadDenyNone,Sys.DataDir+'\FORM'+Strr(I)+'.DAT') then Goto Done;
  B:=1;
  Z:=User.Form[I];
  Repeat
    If (Data^[B]='~') and (Upper(Data^[B+1])='P') and (Upper(Data^[B+2])='S') then
      Begin
        Getkey;
        Inc(B,2);
      End else
    If Data^[B] in ['~','*'] then
      Begin
        Print(Vstring(Z));
        Inc(B,2);
        Inc(Z);
      End else Print(Data^[B]);
    Inc(B);
  Until (B>L) or (Logoff);
  CloseV;
  ShowForm:=True;
  Done:
  Dispose(Data);
End;

FUNCTION GetInfoForm(I:Byte):Word; { Returns position of InfoForm Data }
VAR F:File; S:String; L,B:Integer; C:Char;
LABEL Done;
Begin
  New(Data);
  GetInfoForm:=0;
  S:=Sys.AnsiDir+'\INFOFORM.'+Strr(I);
  If Not Exist(S) then Goto Done;
  Assign(F,S);
  Reset(F,1);
  BlockRead(F,Data^,SizeOf(Data^),L);
  Close(F);
  If Not OpenV(WriteDenyNone,Sys.DataDir+'\FORM'+Strr(I)+'.DAT') then Goto Done;
  Seek(Vfile,FileSize(Vfile));
  GetInfoForm:=FileSize(Vfile) div 81;
  If L=0 then Goto Done;
  B:=1;
  Repeat
    FillChar(S,81,#0);
    If Data^[B]='*' then
      Begin
        Limit(S,255,0);
        Vwrite(S);
      End else
    If Data^[B]='~' then
      Begin
        Inc(B);
        If (Upper(Data^[B])='Y') and (Upper(Data^[B+1])='N') then
          Begin
            Repeat C:=Upcase(Getkey); Until (C in ['Y','N',#13]) or (Logoff);
            Case C of
              #13,'Y':S:='Yes';
              'N':S:='No';
            End;
            Vwrite(S);
          End else
        If (Upper(Data^[B])='N') and (Upper(Data^[B+1])='Y') then
          Begin
            Repeat C:=Upcase(Getkey); Until (C in ['Y','N',#13]) or (Logoff);
            Case C of
              'Y':S:='Yes';
              #13,'N':S:='No';
            End;
            Vwrite(S);
          End else
        If (Data^[B] in ['0'..'9']) and (Data^[B+1] in ['0'..'9']) then
          Begin
            Limit(S,Intt(Data^[B]+Data^[B+1]),0);
            Vwrite(S);
          End else
        If (Upper(Data^[B])='P') and (Upper(Data^[B+1])='S') then
          Begin
            GetKey;
          End else Dec(B,2);
        Inc(B);
      End else Print(Data^[B]);
    inc(B);
  Until (B>L) or (Logoff);
  CloseV;
  Done:
  Dispose(Data);
End;

FUNCTION Add2Voting(I:Word):Word;
VAR B:Byte;
LABEL Done;
Begin
  Add2Voting:=0;
  New(Nuv);
  If Not OpenV(WriteDenyNone,Sys.DataDir+'\NUV.DAT') then Goto Done;
  Seek(Vfile,FileSize(Vfile));
  FillChar(Nuv^,SizeOf(Nuv^),#0);
  Nuv^.Alias:=User.Alias;
  Nuv^.Number:=User.Number;
  Nuv^.InfoForm:=I;
  Nuv^.YesVotes:=0;
  Nuv^.NoVotes:=0;
  Nuv^.Users:=0;
  Nuv^.Deleted:=False;
  For B:=1 to 10 do Nuv^.Comments[B]:='';
  For B:=1 to 40 do
    Begin
      Nuv^.Voted[B]:=0;
      Nuv^.User[B]:=0;
    End;
  If WriteV(Nuv^) then Add2Voting:=FilePos(Vfile) div SizeOf(Nuv^);
  CloseV;
  Done:
  Dispose(Nuv);
End;

FUNCTION CopyFile(Name,OldDir,NewDir:String):Boolean;
VAR Ofile,Nf:File; L:Integer;
Begin
  CopyFile:=False;
  While OldDir[Length(OldDir)]='\' do Dec(OldDir[0]);
  While NewDir[Length(NewDir)]='\' do Dec(NewDir[0]);
  If Not Exist(OldDir+'\'+Name) then Exit;
  Assign(Ofile,OldDir+'\'+Name);
  Assign(Nf,NewDir+'\'+Name);
  Reset(Ofile,1);
  If IOresult<>0 then Exit else
    Begin
      Rewrite(NF,1);
      If IOresult<>0 then
        Begin
          Close(Ofile);
          Exit;
        End;
    End;
  New(Data);
  Repeat
    BlockRead(Ofile,Data^,SizeOf(Data^),L);
    Ignore:=IOresult;
    If Ignore=0 then
      Begin
        BlockWrite(Nf,Data^,L);
        Ignore:=IOresult;
      End;
  Until (L=0) or (Ignore<>0);
  Close(Ofile);
  Close(Nf);
  If Ignore=0 then Erase(Ofile);
  Dispose(Data);
  CopyFile:=True;
End;

PROCEDURE OpenSystemLogs;
Begin
End;

PROCEDURE AddtoSystemLogs(S:String);
Begin
End;

FUNCTION UserOnLine(B:Integer):Boolean;
VAR F:File;
Begin
  If Not Sys.MultiNodes then Exit;
  GetSem(Sys.MainNodeDir+'\'+Strr(B)+'.SEM');
  Assign(F,Sys.MainNodeDir+'\'+Strr(B)+'.NDE');
  Reset(F);
  If IOresult<>0 then UserOnline:=False else
    Begin
      UserOnline:=True;
      Close(F);
    End;
  ReleaseSem(Sys.MainNodeDir+'\'+Strr(B)+'.SEM');
End;

FUNCTION NodeLocation(B:Integer):String;
VAR F:File of NodeRec; Node:NodeRec;
Begin
  If Not Sys.MultiNodes then Exit;
  GetSem(Sys.MainNodeDir+'\'+Strr(B)+'.SEM');
  Assign(F,Sys.MainNodeDir+'\'+Strr(B)+'.NDE');
  Reset(F);
  Read(F,Node);
  Close(F);
  NodeLocation:=Node.Location;
  ReleaseSem(Sys.MainNodeDir+'\'+Strr(B)+'.SEM');
End;

PROCEDURE UpdateOnline(Loc:String);
VAR F:File of NodeRec; Node:NodeRec; I:Byte;
Begin
  If Not Sys.MultiNodes then Exit;
  GetSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  Assign(F,Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.NDE');
  Rewrite(F);
  Node.Alias:=User.Alias;
  Node.From:=User.City+', '+User.State;
  Node.Location:=Loc;
  Write(F,Node);
  Close(F);
  ReleaseSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  I:=IOresult;
End;

PROCEDURE UsersOnline(Format:String);
VAR I:Integer; F:File of NodeRec; Node:NodeRec; B:Integer;
Begin
  If Not Sys.MultiNodes then
    Begin
      SSC(4);
      Print('This is not a multi-node system.'#13);
      Exit;
    End;
  For I:=1 to Sys.Nodes do
    Begin
      Assign(F,Sys.MainNodeDir+'\'+Strr(I)+'.NDE');
      Reset(F);
      If IOresult=0 then
        Begin
          Read(F,Node);
          SSC(1); Print('Node '+Strr(I)+': ');
          SSC(3); PrintLn(Node.Alias+' from '+Node.From);
          Close(F);
        End else
        Begin
          SSC(1); Print('Node '+Strr(I)+': ');
          SSC(3); Println('No User Currently Online.');
        End;
    End;
End;

PROCEDURE ChatMultiNode;
Begin
End;

PROCEDURE UserOnNode;
VAR F:File of NodeRec; Node:NodeRec; I:Byte;
Begin
  If Not Sys.MultiNodes then Exit;
  GetSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  Assign(F,Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.NDE');
  Rewrite(F);
  Node.Alias:=User.Alias;
  Node.From:=User.City+', '+User.State;
  Node.Location:='Logging On.';
  Write(F,Node);
  Close(F);
  ReleaseSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  I:=IOresult;
End;

PROCEDURE LoggingOnNode;
VAR F:File of NodeRec; Node:NodeRec; I:Byte;
Begin
  If Not Sys.MultiNodes then Exit;
  GetSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  Assign(F,Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.NDE');
  Rewrite(F);
  Node.Alias:='User Logging On';
  Node.From:='Unknown Location';
  Node.Location:='Logging On.';
  Write(F,Node);
  Close(F);
  ReleaseSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  I:=IOresult;
End;

PROCEDURE UserOffNode;
VAR F:File; I:Byte;
Begin
  If Not Sys.MultiNodes then Exit;
  GetSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  Assign(F,Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.NDE');
  Erase(F);
  ReleaseSem(Sys.MainNodeDir+'\'+Strr(Sys.NodeNumber)+'.SEM');
  I:=IOresult;
End;

FUNCTION SaveStatus:Boolean;
VAR F:File of StatusRec;
Begin
  SaveStatus:=False;
  SetFileMode(NormalMode);
  Assign(F,'STATUS.DAT');
  Rewrite(F);
  If IOresult<>0 then Exit;
  Write(F,Sys);
  Close(F);
  If IOresult=0 then SaveStatus:=True;
End;

FUNCTION SaveStrings:Boolean;
VAR F:File of StringRec;
Begin
  SaveStrings:=False;
  SetFileMode(NormalMode);
  Assign(F,Sys.DataDir+'\STRINGS.DAT');
  Reset(F);
  If IOresult<>0 then ReWrite(F);
  If IOresult<>0 then Exit;
  Write(F,Strings^);
  Close(F);
  If IOresult=0 then SaveStrings:=True;
End;

FUNCTION MakeStrings:Boolean;
VAR F:File of StringRec; I:Byte;
Begin
  MakeStrings:=False;
  FillChar(Strings^,SizeOf(Strings^),#0);
  Assign(F,Sys.DataDir+'\STRINGS.DAT');
  SetFileMode(WriteDenyNone);
  Repeat
    Rewrite(F);
    I:=IOresult;
    If I=5 then Delay(300);
  Until (I<>5);
  SetFileMode(NormalMode);
  If I<>0 then Exit;
  Strings^.Detect:='Detecting Terminal Emulation';
  Strings^.Ansi:='Ansi Detected!';
  Strings^.Avatar:='Avatar Detected!';
  Strings^.Ogi:='OGi/OGt Detected!';
  Strings^.None:='No Terminal Emulation Detected!';
  Strings^.Pause:=' PAUSE  :';
  Strings^.Init:='ATZ';
  Strings^.Hang:='ATH0';
  Strings^.Dial:='ATDT';
  Strings^.Answer:='ATA';
  Strings^.OffHook:='ATM0H1';
  Strings^.Shell:='SysOp has Shelled to Dos...';
  Strings^.EditorLine:='Command (?/Help):';
  Strings^.Hidden:='.';
  Strings^.Suffix:='X';
  Repeat
    Write(F,Strings^);
    I:=IOresult;
    If I=5 then Delay(300);
  Until (I<>5);
  If I<>5 then
    Begin
      Close(F);
      Exit;
    End;
  Close(F);
  MakeStrings:=True;
  Repeat Until IOresult=0;
End;

FUNCTION LoadStrings:Boolean;
VAR F:File of StringRec; I:Byte; S:String;
LABEL Done;
Begin
  LoadStrings:=False;
  S:=Sys.DataDir+'\Strings.DAT';
  If Not Exist(S) then If Not MakeStrings then Exit else Goto Done;
  Assign(F,S);
  SetFileMode(ReadDenyNone);
  Repeat
    Reset(F);
    I:=IOResult;
    If I=5 then Delay(300);
  Until (I<>5);
  SetFileMode(NormalMode);
  If I<>0 then If Not MakeStrings then Exit else Goto Done;
  Repeat
    Read(F,Strings^);
    I:=IOresult;
    If I=5 then Delay(300);
  Until (I<>5);
  Close(F);
  If I<>0 then If Not MakeStrings then Exit;
  Done:
  LoadStrings:=True;
  Repeat Until IOresult=0;
End;

FUNCTION LoadScreen(I:Integer):Boolean;
VAR F:File; L:Integer;
Begin
  LoadScreen:=False;
  Assign(F,'OTERA.DAT');
  Reset(F,1);
  If IOresult<>0 then Exit;
  If I=2 then Seek(F,4000);
  Case I of
    1:BlockRead(F,Screen,4000,L);
    2:BlockRead(F,Screen,6880,L);
  End;
  Close(F);
  If IOresult=0 then LoadScreen:=True;
End;

PROCEDURE ReadDataFiles;
VAR B:Byte;
Begin
  Writeln('Reading STATUS.DAT... Done!'); Delay(100);
  Write('Reading STRINGS.DAT...'); Delay(100);
  If LoadStrings then Writeln(' Done!') else
    Begin
      Writeln(' Error!');
      Halt(4);
    End;
  Write('Reading OTERA.DAT...'); Delay(100);
  If Sys.LastWin then B:=2 else B:=1;
  If LoadScreen(B) then Writeln(' Done!') else
    Begin
      Writeln(' Error!');
      Halt(5);
    End;
  If Sys.LastWin then TextMode(258);
End;

FUNCTION AutoDetect:Emulation_Set;
VAR I:Integer; C:Char;
Begin
  AutoDetect:=Ascii;
  ClrInPut;
  ClrOutPut;
  If OnLocal then
    Begin
      AutoDetect:=Ansi;
    End else
    Begin
      Repeat If ChWait then GetKey Until Not ChWait;
      SendStr(#27+'[6n');
      I:=1;
      Repeat
        Delay(1);
        Inc(I);
      Until (I=1000) or (Logoff) or (ChWait);
      If ChWait then
        Begin
          C:=GetKey;
          If (C=#27) Then AutoDetect:=Ansi;
          Repeat If ChWait then Getkey Until Not ChWait;
        End;
    End;
End;

FUNCTION SendInitString:Boolean;
VAR S:String; I:Byte; C:Char; B:integer; D:Byte;
Begin
  If Sys.LastWin then D:=42 else D:=24;
  FastWriteXY(2,D,#15#17'Initializing Modem: '#12+Strings^.Init);
  ClrInput;
  SendString(Strings^.Init+#13);
  Delay(1500);
  B:=0;
  Repeat
    Delay(1);
    Inc(B);
  Until (B=3000) or (CharsWaiting) or (KeyPressed);
  If B=3000 then
    Begin
      FastWriteXY(2,D,Fill(' ',Length(Strings^.Init)+22));
      Exit;
    End;
  S:='';
  Repeat
    C:=GetChar;
    If Not (C in [#13,#10]) then S:=S+C;
  Until (Upper(S)=Upper(Strings^.Init)) or (KeyPressed);
  S:='';
  Repeat
    C:=GetChar;
    If Not (C in [#13,#10]) then S:=S+C;
  Until (C in [#13,#10]) and (S<>'') or (KeyPressed);
  Repeat
    If CharsWaiting then C:=GetChar;
  Until (Not CharsWaiting) or (KeyPressed);
  FastWriteXY(2,D,Fill(' ',Length(Strings^.Init)+22));
  FastWriteXY(2,D,#15'Modem Result: '#12+S);
  Delay(1500);
  FastWriteXY(2,D,Fill(' ',Length(S)+15));
End;

PROCEDURE EraseDir(Dir:String);
VAR S:SearchRec; F:File; B:Boolean;
Begin
  FindFirst(Dir+'\*.*',$00,S);
  B:=DosError=0;
  If B then
    Begin
      Assign(F,Dir+'\'+S.Name);
      Erase(F);
    End;
  Repeat
    FindNext(S);
    B:=DosError=0;
    If B then
      Begin
        Assign(F,Dir+'\'+S.Name);
        Erase(F);
      End;
  Until (Not B);
End;

FUNCTION DisplayFont(I:LongInt):Boolean;
TYPE FontType=Array[1..4096] of Byte;
VAR F:File of FontType; Regs:Registers; Font:FontType;
LABEL Die;
Begin
  DisplayFont:=False;
  If I=0 then Goto Die;
  Assign(F,'OTERA.FNT');
  Reset(F);
  If IOresult<>0 then Exit;
  Seek(F,I-1);
  If IOresult<>0 then Exit;
  Read(F,Font);
  If IOresult<>0 then Exit;
  Close(F);

  Die:
  Regs.Ah:=$0F;
  Intr($10,Regs);
  Regs.Ah:=00;
  Intr($10,Regs);
  If I=0 then
    Begin
      Displayfont:=True;
      Exit;
    End;

  Regs.Ax:=$1100;
  Regs.Bx:=$1000;
  Regs.Cx:=$0100;
  Regs.Dx:=$0000;
  Regs.Bp:=Ofs(Font);
  Regs.Es:=Seg(Font);
  Intr($10,Regs);

  DisplayFont:=True;
End;

PROCEDURE Pause;
VAR C:Char;
Begin
  Case Sys.PauseType of
    1,7:Begin GoXY(1,24); Tran(Strings^.Pause); GetKey; End;
    2,8:Begin Tran(Strings^.Pause); GetKey; End;
    3:GetKey;
    4,9:Begin
        GoXY(1,24);
        Tran(Strings^.Pause);
        Repeat C:=Getkey; Until (Logoff) or (C=^M);
      End;
    5,10:Begin
        Tran(Strings^.Pause);
        Repeat C:=Getkey; Until (Logoff) or (C=^M);
      End;
    6:Repeat C:=Getkey until (Logoff) or (C=^M);
  End;
  If Sys.PauseType in [7..10] then Del(TranLen(Strings^.Pause));
End;

PROCEDURE TheWall;
VAR I:Integer; F:File of WallRec; S:String;
Begin
  SetFileMode(NormalMode);
  Assign(F,Sys.DataDir+'\THEWALL.DAT');
  Reset(F);
  If IOresult<>0 then
    Begin
      Rewrite(F);
      For I:=1 to 15 do Wall.Quote[I]:='';
      Wall.Total:=0;
      Write(F,Wall);
    End else Read(F,Wall);
  Close(F);
  Show('THEWALL',False,False);
  USC(0);
  If Wall.Total<>0 then
    For I:=1 to Wall.Total do
      Begin
        USC(0);
        Tran(Wall.Quote[I]);
        If I<>Wall.Total then Cr;
      End
   Else Println('The wall is empty!');
  Cr;
  USC(1); Tran(Strings^.TheWall);
  Case YesNo(False,User.YesNoBar) of
    True:Begin
           Cr;
           Tran(Strings^.Fill[19]);
           Limit(S,80,0);
        If S<>'' then
          Begin
           If Wall.Total<15 then
             Begin
               Inc(Wall.Total);
               Wall.Quote[Wall.Total]:=S;
             End else
             Begin
               For I:=1 to 14 Do Wall.Quote[I]:=Wall.Quote[I+1];
               Wall.Quote[15]:=S;
             End;
           Reset(F);
           If IOresult<>0 then Rewrite(F);
           Write(F,Wall);
           Close(F);
          End;
           Cr;
           Cr;
         End;
    False:Print(#13#13);
  End;
End;

PROCEDURE ListActiveNodes;
VAR F:File of NodeRec; Node:NodeRec; I:Integer;
Begin
  For I:=1 to Sys.Nodes do
    Begin
      GetSem(Sys.MainNodeDir+'\'+Strr(I)+'.SEM');
      Assign(F,Sys.MainNodeDir+'\'+Strr(I)+'.NDE');
      Reset(F);
      If IOresult=0 then
        Begin
          Read(F,Node);
          Close(F);
          MNprint(Node.Alias+' is on node '+Strr(I)+'.');
        End;
      ReleaseSem(Sys.MainNodeDir+'\'+Strr(I)+'.SEM');
    End;
End;

VAR Cfile:File;

FUNCTION OpenConference(Mode:Byte):Boolean;
VAR S:String; I:Byte;
Begin
  OpenConference:=False;
  S:=Sys.DataDir+'\FORUM.LST';
  SetFileMode(Mode);
  Assign(Cfile,S);
  If Not Exist(S) then
    Begin
      Rewrite(Cfile,1);
      If IOresult<>0 then Exit;
    end else
    Begin
      Repeat
        Reset(Cfile,1);
        I:=IOresult;
        If I=5 then Delay(300);
      Until (I<>5) or (Logoff);
      If I<>0 then Exit;
    End;
  SetFileMode(NormalMode);
  OpenConference:=True;
End;

PROCEDURE CloseIt;
Begin
  Close(Cfile);
End;

FUNCTION LoadConference(I:Integer):Boolean;
VAR L:Integer;
Begin
  LoadConference:=False;
  Repeat L:=IOresult; Until L=0;
  Seek(Cfile,(I-1)*SizeOf(ConferenceRec));
  Repeat
    BlockRead(Cfile,Forum^,SizeOf(Forum^),L);
    I:=IOresult;
    If I=5 then Delay(300);
  Until (L<SizeOf(Forum^)) or (I<>5);
  If (L<SizeOf(Forum^)) or (I<>0) then Exit;
  LoadConference:=True;
End;

FUNCTION SaveConference(I:Integer):Boolean;
VAR L:Integer;
Begin
  SaveConference:=False;
  CloseIt;
  If Not OpenConference(WriteDenyNone) then Exit;
  Repeat L:=IOresult; Until L=0;
  Seek(Cfile,(I-1)*SizeOf(ConferenceRec));
  Repeat
    BlockWrite(Cfile,Forum^,SizeOf(Forum^));
    I:=IOresult;
    If I=5 then Delay(300);
  Until (I<>5);
  If I<>0 then Exit;
  SaveConference:=True;
  CloseIt;
  OpenConference(ReadDenyNone);
End;

PROCEDURE EditIt;
VAR C:Char; S:String; I:Integer; Total:Integer;

FUNCTION F(Z:ForumSet):String;
Begin
  If Z=Transfers then F:='Files Conference' else
  If Z=Messages then F:='Message Conference' else
  If Z=Both then F:='Files and Message Conference';
End;

PROCEDURE Draw;
Begin
  Cls;
  SSC(1); Print('['); SSC(3); Print(Strr(I));
  SSC(1); Print('/'); SSC(3); Print(Strr(Total));
  SSC(1); Println(']');
  FunctionTop;
  Command('1','Description',Forum^.Name);
  Command('2','Access',Forum^.Access);
  Command('3','Input',Forum^.Input);
  Command('4','Type',F(Forum^.Ctype));
  FunctionBottom;
End;

PROCEDURE GetIt(C:Char);
VAR S:String; I:Byte;
Begin
  SSC(1);
  Print('New ');
  Case C of
    '1':Print('Description');
    '2':Print('Access Level');
    '3':Print('Input');
  End;
  Print(': '); SSC(0);
  Case C of
    '1':I:=50;
    '2':I:=15;
    '3':I:=30;
  End;
  Limit(S,I,0); Cr;
  Case C of
    '1':If S<>'' then Forum^.Name:=S;
    '2':Forum^.Access:=S;
    '3':If S<>'' then Forum^.Input:=S;
  End;
End;

LABEL Done;
Begin
  SSC(1); Print('Conference to Modify: '); SSC(0); Limit(S,5,2); Cr;
  I:=Intt(S);
  If I=0 then Exit;
  If Not OpenConference(ReadDenyNone) then Exit;
  Total:=FileSize(Cfile) div SizeOf(Forum^);
  If Not LoadConference(I) then Goto Done;
  Repeat
    Draw;
    Prompt;
    Repeat C:=Upcase(Getkey); Until (C in ['Q','+','-','_','=','1'..'4']) or (logoff);
    Println(C);
    If C in ['+','='] then
      Begin
        SaveConference(I);
        If I=Total then I:=1 else Inc(I);
        LoadConference(I);
      End;
    If C in ['-','_'] then
      Begin
        SaveConference(I);
        If I=1 then I:=Total else Dec(I);
        LoadConference(I);
      End;
    If C in ['1'..'3'] then GetIt(C);
    If C='4' then
      Case Forum^.Ctype of
        Both:Forum^.Ctype:=Messages;
        Messages:Forum^.Ctype:=Transfers;
        Transfers:Forum^.Ctype:=Both;
      End;
  Until (C='Q') or (Logoff);
  SaveConference(I);
  Done:
  CloseIt;
End;

PROCEDURE ClearForum;
Begin
  Forum^.Name:='Generic Conference';
  Forum^.Number:=FileSize(Cfile) div SizeOf(Forum^);
  Forum^.Access:='';
  Forum^.Input:=Strr(Forum^.Number+1);
  Forum^.Ctype:=Both;
End;

PROCEDURE ForumEditor;
VAR C:Char;

PROCEDURE Draw;
VAR D,I,L:Integer; B:Boolean;
Begin
  Cls;
  If Not OpenConference(ReadDenyNone) then
    Begin
      SSC(4); Print('Error opening Conference file!');
      Cr;
      Exit;
    End;
  If FileSize(Cfile)=0 then
    Begin
      SSC(4); Print('There are no Conferences!');
      Cr;
      Exit;
    End;
  MenuTop;
  I:=1;
  Repeat
    repeat
    BlockRead(Cfile,Forum^,SizeOf(Forum^),L);
    D:=IOresult;
    B:=(L=SizeOf(Forum^));
    If D=5 then Delay(300);
    until (D<>5);
    If B then ListCmd(I,Forum^.Name);
    Inc(I);
  Until (Not B) or (Logoff) or (D<>0);
  MenuBottom;
  CloseIt;
End;

PROCEDURE AddForum;
Begin
  If Not OpenConference(WriteDenyNone) then Exit;
  Seek(Cfile,FileSize(Cfile));
  ClearForum;
  BlockWrite(Cfile,Forum^,SizeOf(Forum^));
  CloseIt;
End;

Begin
  Repeat
    Draw;
    Prompt;
    Repeat C:=Upcase(Getkey); Until (C in ['A','M','Q','?']);
    Println(C);
    If C='M' then EditIt;
    If C='A' then AddForum;
  Until (C='Q') or (Logoff);
End;

PROCEDURE GotoConference;
VAR S:String;

PROCEDURE ListC;
VAR I:Integer; B:Boolean;
Begin
  I:=1;
  Show('FLISTTOP',False,False);
  Repeat
    B:=LoadConference(I);
    If B then
      Begin
        SSC(3); Print(Strr(I)); Repeat Print(#32) Until WhereX=8;
        Tran(Forum^.Name); Cr;
      End;
    Inc(I);
  Until (Logoff) or (Not B);
  Show('FLISTBOT',False,False);
End;

Begin
  If Not OpenConference(readDenyNone) then Exit;
  If DataI>0 then
    Begin
      If Not LoadConference(DataI) then
        Begin
          If DataS<>'' then Tran(DataS);
        End else
        Begin
          ForumNum:=DataI;
{          LoadFirstBase;}
        End;
    End else
    Begin
      Repeat
        Limit(S,5,2);
        If S='?' then ListC;
      Until (S<>'?') or (Logoff);
      If Intt(S)>0 then
        If Not LoadConference(Intt(S)) then
          Begin
            If DataS<>'' then Tran(DataS);
          End else
          Begin
            ForumNum:=Intt(S);
{            LoadFirstBase;}
          End;
    End;
  CloseIt;
End;

PROCEDURE UserIsOn(L:Integer);
VAR Today:TimeArr; Color:Word;
Begin
  If LoadUser(L,User) then { twas loaded, remember? }
    Begin
      SetBit(Status,1,True);
      Inc(User.Calls);
      TimeCheck:=False;
      If User.TimeLimit>0 then
        Begin
          SetTime(Today);
          If (User.TimeToday>0) and (Not SameDay(Today,User.LastOn)) then
            User.TimeToday:=0;
          If User.TimeToday>=User.TimeLimit then
            Begin
              SSC(4);
              Println('You have already used up your daily time limit!');
              Delay(2000);
              Println('Call back tommorow!');
              QuickLogoff:=True;
            End;
          TimeLeft:=User.TimeLimit-User.TimeToday;
          MaxTimeLeft:=TimeLeft;
          TimeCheck:=True;
        End else
        Begin
          TimeLeft:=0;
          Color:=TextAttr;
          Tc(4);
          Tb(7);
          FastWriteXY(74,43,'');
          TextAttr:=Color;
        End;
     Poplines;
     UserInfo;
     UserOnNode;
   End;
End;

PROCEDURE SaveHim;
VAR I:INteger;
Begin
  If Logoff then Exit;
  User.FilePoints:=0;
  If Not ValidateUser(User,1) then
    Begin
      User.FilePoints:=5;
      User.Expiration:='00/00/00';
      User.Note:='New Looser';
      User.Sl:=5;
      User.Dsl:=5;
      User.TimeLimit:=30;
      User.BankMaximum:=120;
      User.PostCallRatio:=5; { 5 to 1 }
      User.FilesRatio:=3;    { 3 to 1 }
      User.FilePointRatio:=3;
      User.MaximumDeposit:=15;
    End;
  User.Number:=UserNum;
  {--- SysOp Definable ---}
  User.Deleted:=False;
  User.TimeToday:=0;
  User.Posts:=0;
  User.Calls:=1;
  User.Lines:=24;
  User.Emulation:=Emulation;
  User.Prompt:=1;
  User.LineFeeds:=True;
  User.Pause:=True;
  User.YesNoBar:=True;
  User.HotKeys:=False;
  SetTime(User.LastOn);
  User.LastMsgNewScan:=0;
  User.LastFileNewScan:=0;
  User.Balance:=0;
  User.DepositToday:=0;
  User.Kuploaded:=0;
  User.Kdownloaded:=0;
  User.FilesUploaded:=0;
  User.FilesDownloaded:=0;
  User.Colors:=Sys.Colors;
  For I:=1 to 30 do User.Flag[I]:=False;
  For I:=1 to 1024 do User.LastScan[I]:=0;
  User.EmailScan:=0;
  User.MenuSet:=1;
  User.Form[1]:=0;
  User.Form[2]:=0;
  User.Form[3]:=0;
  User.Form[4]:=0;
  If Not Logoff then
    Begin
      User.Form[5]:=GetInfoForm(5);
      If Not Logoff then
        Begin
          User.NuvLoc:=Add2Voting(User.Form[5]);
          If Not Logoff then
            Begin
              If SaveNew then
                Begin
                  SetBit(Status,1,True);
                  Inc(Sys.NewUsers);
                End;
            End;
        End;
    End;
End;

PROCEDURE DoScript(Len:Byte);
CONST Loop:Byte=1; L:Byte=64; UserON:Boolean=False; Loops:Byte=1; LoopTo:Byte=2;
VAR B,I:Byte; S,S2,S3:String; Nor:Boolean; Urt:UserExistRec;

PROCEDURE CheckIt(S:String);
Begin
  If Upper(S)='LOOP' then
    Begin
      Loop:=I;
      Loops:=1;
     End else
  If Upper(S)='CLS' then Cls else
  If Upper(S)='GOTO LOOP' then
    Begin
      I:=Loop;
      FromTop(I);
    End else
  If Upper(S)='CLEAR STRING LEN' then
    Begin
      Print(Fill(#32,Length(S3)));
      Print(Fill(#8,Length(S3)));
    End else
  If (S[1] in ['"','^','''']) and (S[Length(S)]=S[1]) then
    Begin
      Delete(S,1,1);
      Dec(S[0]);
      Tran(S);
    End else
  If Pos('GOTO ',Upper(S))>0 then
    Begin
      Delete(S,1,5);
      B:=0;
      Repeat
        Inc(B);
        FromTop(B);
      Until (Upper(Top^.Text)=Upper(':LAB '+S)) or (B=Len) or (Logoff);
      If Upper(Top^.Text)=Upper(':LAB '+S) then
        Begin
          I:=B-1;
          FromTop(I);
        End else FromTop(I);
    End else
  If Upper(S)='END SUB' then
    Begin
      I:=LoopTo;
      FromTop(I);
    End else
  If Upper(S)='PAUSE' then Pause else
  If Pos('GOTOXY',Upper(S))>0 then
    Begin
      Delete(S,1,7);
      Dec(S[0]);
      S2:='';
      Repeat
        S2:=S2+S[1];
        Delete(S,1,1);
      Until (S[1]=',') or (Logoff) or (S[1]=#0);
      Delete(S,1,1);
      GoXY(Intt(S2),Intt(S));
    End else
  If Pos('RUN',Upper(S))>0 then
    Begin
      Delete(S,1,4);
      B:=0;
      Repeat
        Inc(B);
        FromTop(B);
      Until (Upper(Top^.Text)=':SUB '+Upper(S)) or (Logoff) or (B=Len);
      If Upper(Top^.Text)=':SUB '+Upper(S) then
        Begin
          LoopTo:=I;
          I:=B;
          FromTop(I);
        End else FromTop(I);
    End else
  If Pos('DELAY',Upper(S))>0 then
    Begin
      Delete(S,1,6);
      Dec(S[0]);
      Delay(Intt(S));
    End else
  If Pos('INPUT STRING',Upper(S))>0 then
    Begin
      Delete(S,1,13);
      If (Upper(S)='HIDDEN') or (Upper(S)='SYSTEM') or
         (Upper(S)='PASSWORD') then
        Begin
          If Upper(S)='PASSWORD' then Urt.Password:='PWD INPUT';
          TopHidden(Urt.Password);
          Limit(S3,L,1);
        End else Limit(S3,L,0);
      If Upper(S)='PASSWORD' then
        Begin
          User.Password:=S3;
          Urt.Password:=S3;
        End else
      If Upper(S)='NAME' then User.Name:=S3 else
      If Upper(S)='ADDRESS' then User.Address:=S3 else
      If Upper(S)='CITY' then User.City:=S3 else
      If Upper(S)='STATE' then User.State:=S3 else
      If Upper(S)='PHONE' then User.Phone:=S3 else
      If Upper(S)='BORN' then User.BirthDay:=S3 else
      If Upper(S)='ZIP' then User.Zip:=S3 else
      If Upper(S)='ALIAS' then
        Begin
          User.Alias:=S3;
          UserON:=UserExist(S3,Urt);
          If UserOn then User.Number:=Urt.Number;
        End;
    End else
  If (S[1]='%') and (S[2]='%') then
    Begin
      Delete(S,1,2);
      If S[Length(S)] in ['|','!'] then Dec(S[0]);
      Show(S,False,S[Length(S)+1]='|');
    End;
End;

Begin
  I:=1;
  Repeat
    S:=Top^.Text;
    Nor:=False;
    If (S[1]=':') and (S[2]<>':') then
      Begin
        Delete(S,1,1);
        If S[1]='!' then
          Begin
            Nor:=True;
            Delete(S,1,1);
          End;
        If S[1] in ['0'..'9'] then
          Begin
            S2:=S[1];
            Delete(S,1,1);
            While (S[1] in ['0'..'9']) do
              Begin
                S2:=S2+S[1];
                Delete(S,1,1);
              End;
            Delete(S,1,1);
            If (Not Nor) and (Intt(S2)=Loops) then CheckIt(S) else
            If (Nor) and (Intt(S2)<>Loops) then CheckIt(S);
          End else
        If Pos('EXIST',Upper(S))>0 then
          Begin
            Delete(S,1,6);
            If (Not Nor) and (UserOn) then CheckIt(S) else
            If (Nor) and (Not UserOn) then CheckIt(S);
          End else
        If Pos('STRING NULL',Upper(S))>0 then
          Begin
            Delete(S,1,12);
            If (Not Nor) and (S3='') then CheckIt(S) else
            If (Nor) and (S3<>'') then CheckIt(S);
          End else
        If Pos('SYSTEM PASSWORD CHECK',Upper(S))>0 then
          Begin
            Delete(S,1,22);
            If (Not Nor) and (Upper(Sys.SystemPassword)=Upper(S3)) then CheckIt(S) else
            If (Nor) and (Upper(Sys.SystemPassword)<>Upper(S3)) then CheckIt(S);
          End else
        If Pos('INPUT STRING LEN=',Upper(S))>0 then
          Begin
            Delete(S,1,17);
            L:=Intt(S);
          End else
        If Upper(S)='USER IS ON' then UserIsOn(Urt.Number) else
        If Upper(S)='SAVE USER' then SaveHim else
        If Pos('NUM',Upper(S))>0 then
          Begin
            Delete(S,1,4);
            If (Not Nor) and (Intt(S3)>0) then CheckIt(S) else
            If (Nor) and (Intt(S3)=0) then CheckIt(S);
          End else
        If Pos('SYSTEM PASSWORD',Upper(S))>0 then
          Begin
            Delete(S,1,16);
            If (Not Nor) and (Sys.SystemPassword<>'') then CheckIt(S) else
            If (Nor) and (Sys.SystemPassword='') then CheckIt(S);
          End else
        If Pos('VALIDATED',Upper(S))>0 then
          Begin
            Delete(S,1,10);
            If (Not Nor) and (Urt.Sl>Sys.NewUserSl) then CheckIt(S) else
            If (Nor) and (Sys.NewUserSl>Urt.Sl) then CheckIt(S);
          End else
        If Pos('PASSWORD CHECK',Upper(S))>0 then
          Begin
            Delete(S,1,15);
            If (Not Nor) and (Upper(Urt.Password)=Upper(S3)) then CheckIt(S) else
            If (Nor) and (Upper(Urt.Password)<>Upper(S3)) then CheckIt(S);
          End else
        If Pos('UNTIL',Upper(S))>0 then
          Begin
            Delete(S,1,6);
            If Loops<>Intt(S) then
              Begin
                I:=Loop;
                FromTop(I);
                Inc(Loops);
              End;
          End else CheckIt(S);
      End else
    If (S[2]=':') then
      Begin
        Delete(S,1,1);
        Tran(S);
      End else Tran(S);
    Inc(I);
    NextLine;
  Until (I>Len) or (logoff);
End;

PROCEDURE ReadScript(S:String);
VAR F:Text; I,Len:Byte;
Begin
  StartMessage;
  If S[2]<>':' then S:=Sys.DataDir+'\'+S+'.SCR';
  If Not Exist(S) then Exit;
  MaxL:=255;
  Assign(F,S);
  Reset(F);
  If IOresult<>0 then Exit;
  Len:=1;
  Repeat
    Readln(F,Top^.Text);
    AddEnd;
    NextLine;
    Inc(Len);
  Until (Eof(F)) or (Len>MaxL);
  Dec(Len);
  Close(F);
  Top:=TopPtr;
  If (Deep=1) and (Top^.Text='') then Exit;
  DoScript(Len);
  EndMessage;
End;

PROCEDURE RegisterMessage;
Begin
  Color(11,0);
  Cls;
  Println('OTERA(c) BBS Program Copyright 1992-1993 Power Systems(c) Inc.');
  Color(3,0);
  Println('All Rights Reserved.');
  Cr;
  USC(1); Print('Registered Owner : '); USC(3); Println(Sys.SysOp);
  USC(1); Print('Registered Name  : '); USC(3); Println(Sys.Name);
  USC(1); Print('Serial Number    : '); USC(3); Println('000-216-01');
  USC(1); Print('Version Number   : '); USC(3); Println(Version);
  Color(7,0);
  Cr;
  Println('To obtain a copy of OTERA, contact Mercury on NitroNet, CCiNet, ThunderNet,');
  Println('PlatinumNet, ToXiCNeT, or call any of the following boards:');
  Cr;
  Color(12,0);
  Println('The Adventurer''s Guild       [216] 449-5428       SysOp: The Fly');
  Println('System Crash                 [216] 942-6250       SysOp: Holophax');
  Println('The Fringes                  [216] PRI-VATE       SysOp: Darkened Enmity');
  Cr;
End;

End.
