UNIT Editors;
{$X+,I-,F-,O-}

{ Full-Screen Editor AND Line Editor }

INTERFACE

USES Gentypes,Dos,Crt,Modem,Misc,Files,PCKDTIME,Fossil,BcSHare;

FUNCTION EditMessage(X,Y:Integer):Boolean;
FUNCTION FullScreenEdit:Boolean;
FUNCTION LineEdit:Boolean;

IMPLEMENTATION

PROCEDURE QuoteMessage;
VAR Start:Integer; I:Integer; S:String; B:Boolean; C:Char;
Begin
  Cls;
  Show('QUOTEHDR',False,False);
  Start:=ReplyHeader^.Start;
  I:=1;
  Repeat
    B:=ReadString(Start,S);
    If B then
      Begin
        SSC(7);
        Print(Strr(I)+':');
        Tran(S);
        Cr;
      End;
    Inc(Start);
    Inc(I);
  Until (I>ReplyHeader^.Lines) or (ChWait) or (Not B) or (I=256);
  If ChWait then Getkey;
  Tran(Strings^.Quote);
  Repeat C:=Upcase(Getkey) until (C in [^M,'Q','S','A']) or (Logoff);
  If C=^M then Println('<') else Println(C);
  If C='S' then
    Begin
      SSC(3); Print('Start Quote: '); SSC(0); Limit(S,3,2); Cr;
      I:=Intt(S);
      If I>0 then
        Begin
          SSC(3); Print('End Quote: '); SSC(0); Limit(S,3,2); Cr;
          If Intt(S)>0 then
            Begin
              Start:=ReplyHeader^.Start+I-1;
              I:=1;
              Repeat
                AddEnd;
                NextLine;
                B:=ReadString(Start,Top^.Text);
                If Not (Top^.Text[1] in ['>','',':']) then
                  Top^.Text:='> '+Top^.Text;
                Inc(Start);
                Inc(I);
              Until (I>Intt(S)) or (Not B);
            End;
        End;
    End else
  If C='A' then
    Begin
    End;
End;

FUNCTION EditMessage(X,Y:Integer):Boolean;
Begin
  If X<>0 then MaxX:=X;
  If Y<>0 then MaxL:=Y;
  If Emulation<>Ascii then EditMessage:=FullScreenEdit else
    EditMessage:=LineEdit;
End;

PROCEDURE ShowAll(TopY:Byte);
VAR I:Byte;
Begin
  For I:=TopY to 21 do If Top<>TopPtr then PreviousLine;
  GoXY(1,TopY);
  For I:=TopY to 21 do
    Begin
      Print(Top^.Text);
      ClrEnd; Cr;
      If Top<>EndPtr then NextLine;
    End;
  Print(Top^.Text);
End;

PROCEDURE ShowIt(TopY:Byte);
VAR I:Byte;
Begin
  For I:=TopY to 23 do
    Begin
      GoXY(1,I);
      ClrEnd;
    End;
  GoXY(1,TopY);
  PreviousLine;
  Print(Top^.Text); ClrEnd;
  Cr;
  NextLine;
  Print(Top^.Text); ClrEnd;
  Cr;
End;

FUNCTION FullScreenEdit:Boolean;
CONST Save:Boolean=False; Quit:Boolean=False;
VAR   X,Y:Byte; C:Char; I:Integer; TopY:Byte; Ln:Integer;

PROCEDURE Pad;
Begin
  If Length(Top^.Text)<X then
    Repeat
      Top^.Text:=Top^.Text+#32;
    Until (Length(Top^.Text)>=X) or (Logoff);
End;

PROCEDURE UnPad;
Begin
  While Top^.Text[Length(Top^.Text)]=#32 do Dec(Top^.Text[0]);
End;

PROCEDURE Line(S:String);
Begin
  If LineOn then Exit;
  LineOn:=True;
  Color(15,4);
  GoXY(1,24);
  Print(S);
  ClrEnd;
  SSC(7);
  GoXY(X,Y);
End;

PROCEDURE Return;
LABEL Error1;
Begin
  If (Ln=Deep) then
    Begin
     If AddEnd then
       Begin
         If Y=23 then
           Begin
             ShowIt(TopY);
             Y:=TopY+2;
           End else
           Begin
             Cr;
             Inc(Y);
           End;
         Inc(Ln);
         X:=1;
         UnPad;
         NextLine;
       End else Goto Error1;
    End;
  Exit;
  Error1:
  Line('You have reached the maximum line limit!');
End;

PROCEDURE BackSpace;
Begin
  If X>1 then
    Begin
      Print(#8);
      Dec(Top^.Text[0]);
      Dec(X);
    End else
  If (X=1) and (Ln>1) and (Y>TopY) then
    Begin
      Dec(Y);
      Dec(Ln);
      Top:=YankLine;
      If Length(Top^.Text)>0 then
        Begin
          X:=Length(Top^.Text)+1;
          GoXY(X,Y);
        End else
        Begin
          X:=1;
          GoXY(X,Y);
        End;
    End else
  If (X=1) and (Ln>1) and (Y=TopY) then
    Begin
      Y:=21;
      ShowAll(TopY);
      Top:=YankLine;
      If Top^.Text<>'' then
        Begin
          X:=Length(Top^.Text)+1;
          GoXY(X,Y);
        End else
        Begin
          X:=1;
          GoXY(X,Y);
        End;
      Dec(Ln);
    End;
End;

PROCEDURE Tab;
Begin
  If Length(Top^.Text)<MaxX-5 then
    Begin
      Repeat
        Top^.Text:=Top^.Text+#32;
        Print(#32);
        Inc(X);
      Until (X in [5,10,15,20,25,30,35,40,45,50,55,60,65,70,75]);
    End;
End;

PROCEDURE Extended;
Begin
End;

PROCEDURE Yank;
Begin
  If Deep=1 then
    Begin
      Cr13; ClrEnd;
      X:=1;
      Top^.Text:='';
    End else
    Begin
    End;
End;

PROCEDURE AddTo;
VAR S1:String;
LABEL Error1;
Begin
  If X<MaxX then
    Begin
      Top^.Text:=Top^.Text+C;
      Inc(X);
      Print(C);
    End else
  If (X=MaxX) and (C=#32) then
    Begin
      Unpad;
      If addEnd then
        Begin
          If Y=23 then
            Begin
              ShowIt(TopY);
              Y:=TopY+2;
            End else
            Begin
              Inc(Y);
              Cr;
            End;
          Inc(Ln);
          Unpad;
          NextLine;
          X:=1;
        End else Goto Error1;
    End else
  If X=MaxX then
    Begin
      Unpad;
      Top^.Text:=Top^.Text+C;
      WordWrap(Top^.Text,S1);
      If Ln=Deep then
        Begin
          If AddEnd then
            Begin
              Inc(Ln);
              If Y=23 then
                Begin
                  ShowIt(TopY);
                  Y:=TopY+2;
                End else
                Begin
                  Del(Length(S1));
                  Inc(Y);
                  Cr;
                End;
              NextLine;
              If S1='' then
                Begin
                  X:=1;
                  Top^.Text:='';
                End else
                Begin
                  X:=Length(S1)+1;
                  Print(S1);
                  Top^.Text:=S1;
                End;
              pad;
            End else Goto Error1;
        End else
        Begin
        End;
    End;
  Exit;
  Error1:
  Line('You have reached the maximum line limit!');
End;

FUNCTION OptionLine(VAR Save:Boolean):Boolean;
Begin
  OptionLine:=False;
  SendStr(#13);
  Write(#13);
  Tran(Strings^.EditorLine);
  Repeat C:=Upcase(Getkey); Until (C in ['S','A','Q','C','?']) or (Logoff);
  If C in ['S','A'] then OptionLine:=True;
  If C='S' then Save:=True;
  If C='Q' then QuoteMessage;
  If C='?' then
    Begin
      If Not Show('FSEHELP',False,True) then Show('LINEHLP',False,True);
    End;
  Write(#13);
  SendStr(#13);
  ClrEnd;
End;

Begin
  Quit:=False;
  Save:=False;
  ColorOff:=True;
  Show('FSEHDR',False,False);
  ColorOff:=False;
  Y:=WhereY+1;
  Color(15,4);
  Print(' OTERA BBS Program v1.0  [/] On Line 1 for Help  |00-|31,||0-||7 for Color ');
  SSC(7);
  Line('');
  X:=1;
  TopY:=Y;
  Ln:=1;
  GoXY(X,Y);
  Repeat
    C:=Getkey;
    If (LineOn) and (X<>MaxX) and (Deep<>MaxL) then
      Begin
        Line('');
        LineOn:=False;
      End;
    If (C='/') and (X=1) then Quit:=OptionLine(Save) else
    Case C of
      ^M:Return;
      ^H:BackSpace;
      ^I:Tab;
      ^Y:Yank;
      #0:Extended;
      #32..#255:AddTo;
    End;
  Until (quit) or (Logoff);
  Top:=EndPtr;
  Top:=YankLine;
  Header^.Lines:=Deep;
  Unpad;
  If Deep<>0 then
  If Top^.Text='' then
    Begin
      While (Top^.Text='') and (Deep>1) do
        Begin
          Top:=YankLine;
          Unpad;
          Dec(Header^.Lines);
        End;
    End;
  Unpad;
  If (Top^.Text='') and (Deep<2) then Save:=False;
  FullScreenEdit:=Save;
  Cls;
End;

FUNCTION LineEdit:Boolean;
Begin
End;

End.
